/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.gui.component.InfinityEnergyScreenAddon;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;

public class InfinityEnergyStorage<T extends IComponentHarness>
extends EnergyStorageComponent<T> {
    private final long capacity;
    private long energy = 0L;

    public InfinityEnergyStorage(long capacity, int xPos, int yPos) {
        super(Integer.MAX_VALUE, xPos, yPos);
        this.capacity = capacity;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        long stored = this.getLongEnergyStored();
        int energyReceived = (int)Math.min(this.capacity - stored, Math.min(Long.MAX_VALUE, (long)maxReceive));
        if (!simulate) {
            this.setEnergyStored(stored + (long)energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.energy;
    }

    public void setEnergyStored(long power) {
        this.energy = power;
        if (this.componentHarness != null) {
            this.componentHarness.markComponentForUpdate(false);
        }
    }

    public int getMaxEnergyStored() {
        return (int)this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public long getLongEnergyStored() {
        return this.energy;
    }

    public long getLongCapacity() {
        return this.capacity;
    }

    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("energy", this.energy);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.energy = nbt.func_74763_f("energy");
    }

    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.singletonList(() -> new InfinityEnergyScreenAddon(this.getX(), this.getY(), this));
    }
}

