/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.block_rendering;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.BlockRenderType;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockMaterialMapping {
    public static Object2IntMap<BlockState> createBlockStateIdMap(Int2ObjectMap<List<BlockEntry>> blockPropertiesMap) {
        Object2IntOpenHashMap blockStateIds = new Object2IntOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockStateIdMap$0((Object2IntMap)blockStateIds, arg_0, arg_1));
        return blockStateIds;
    }

    public static Map<Block, RenderType> createBlockTypeMap(Map<NamespacedId, BlockRenderType> blockPropertiesMap) {
        Reference2ReferenceOpenHashMap blockTypeIds = new Reference2ReferenceOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockTypeMap$1((Map)blockTypeIds, arg_0, arg_1));
        return blockTypeIds;
    }

    private static RenderType convertBlockToRenderType(BlockRenderType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case SOLID: {
                return RenderType.func_228639_c_();
            }
            case CUTOUT: {
                return RenderType.func_228643_e_();
            }
            case CUTOUT_MIPPED: {
                return RenderType.func_228641_d_();
            }
            case TRANSLUCENT: {
                return RenderType.func_228645_f_();
            }
        }
        return null;
    }

    private static void addBlockStates(BlockEntry entry, Object2IntMap<BlockState> idMap, int intId) {
        NamespacedId id = entry.getId();
        ResourceLocation resourceLocation = new ResourceLocation(id.getNamespace(), id.getName());
        Block block = (Block)Registry.field_212618_g.func_82594_a(resourceLocation);
        if (block == Blocks.field_150350_a) {
            return;
        }
        Map<String, String> propertyPredicates = entry.getPropertyPredicates();
        if (propertyPredicates.isEmpty()) {
            for (BlockState state : block.func_176194_O().func_177619_a()) {
                idMap.putIfAbsent((Object)state, intId);
            }
            return;
        }
        HashMap properties = new HashMap();
        StateContainer stateManager = block.func_176194_O();
        propertyPredicates.forEach((key, value) -> {
            Property property = stateManager.func_185920_a(key);
            if (property == null) {
                Iris.logger.warn("Error while parsing the block ID map entry for \"block." + intId + "\":");
                Iris.logger.warn("- The block " + resourceLocation + " has no property with the name " + key + ", ignoring!");
                return;
            }
            properties.put((Property<?>)property, (String)value);
        });
        for (BlockState state : stateManager.func_177619_a()) {
            if (!BlockMaterialMapping.checkState(state, properties)) continue;
            idMap.putIfAbsent((Object)state, intId);
        }
    }

    private static boolean checkState(BlockState state, Map<Property<?>, String> expectedValues) {
        for (Map.Entry<Property<?>, String> condition : expectedValues.entrySet()) {
            String actualValue;
            Property<?> property = condition.getKey();
            String expectedValue = condition.getValue();
            if (expectedValue.equals(actualValue = property.func_177702_a(state.func_177229_b(property)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$createBlockTypeMap$1(Map blockTypeIds, NamespacedId id, BlockRenderType blockType) {
        ResourceLocation resourceLocation = new ResourceLocation(id.getNamespace(), id.getName());
        Block block = (Block)Registry.field_212618_g.func_82594_a(resourceLocation);
        blockTypeIds.put(block, BlockMaterialMapping.convertBlockToRenderType(blockType));
    }

    private static /* synthetic */ void lambda$createBlockStateIdMap$0(Object2IntMap blockStateIds, Integer intId, List entries) {
        for (BlockEntry entry : entries) {
            BlockMaterialMapping.addBlockStates(entry, (Object2IntMap<BlockState>)blockStateIds, intId);
        }
    }
}

