/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.shadow_map;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderManager;
import net.coderbot.iris.compat.sodium.impl.shadow_map.SwappableChunkRenderManager;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumWorldRenderer.class})
public class MixinSodiumWorldRenderer {
    @Shadow(remap=false)
    private ChunkRenderManager<?> chunkRenderManager;
    @Unique
    private boolean wasRenderingShadows = false;
    @Shadow(remap=false)
    private double lastCameraX;
    @Shadow(remap=false)
    private double lastCameraY;
    @Shadow(remap=false)
    private double lastCameraZ;
    @Shadow(remap=false)
    private double lastCameraPitch;
    @Shadow(remap=false)
    private double lastCameraYaw;
    @Unique
    private double iris$swapLastCameraX;
    @Unique
    private double iris$swapLastCameraY;
    @Unique
    private double iris$swapLastCameraZ;
    @Unique
    private double iris$swapLastCameraPitch;
    @Unique
    private double iris$swapLastCameraYaw;

    @Unique
    private void swapCachedCameraPositions() {
        double tmp = this.lastCameraX;
        this.lastCameraX = this.iris$swapLastCameraX;
        this.iris$swapLastCameraX = tmp;
        tmp = this.lastCameraY;
        this.lastCameraY = this.iris$swapLastCameraY;
        this.iris$swapLastCameraY = tmp;
        tmp = this.lastCameraZ;
        this.lastCameraZ = this.iris$swapLastCameraZ;
        this.iris$swapLastCameraZ = tmp;
        tmp = this.lastCameraPitch;
        this.lastCameraPitch = this.iris$swapLastCameraPitch;
        this.iris$swapLastCameraPitch = tmp;
        tmp = this.lastCameraYaw;
        this.lastCameraYaw = this.iris$swapLastCameraYaw;
        this.iris$swapLastCameraYaw = tmp;
    }

    @Unique
    private void iris$ensureStateSwapped() {
        if (!this.wasRenderingShadows && ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (this.chunkRenderManager instanceof SwappableChunkRenderManager) {
                ((SwappableChunkRenderManager)this.chunkRenderManager).iris$swapVisibilityState();
                this.swapCachedCameraPositions();
            }
            this.wasRenderingShadows = true;
        } else if (this.wasRenderingShadows && !ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (this.chunkRenderManager instanceof SwappableChunkRenderManager) {
                ((SwappableChunkRenderManager)this.chunkRenderManager).iris$swapVisibilityState();
                this.swapCachedCameraPositions();
            }
            this.wasRenderingShadows = false;
        }
    }

    @Inject(method={"updateChunks"}, at={@At(value="RETURN")})
    private void iris$captureVisibleBlockEntities(ActiveRenderInfo camera, ClippingHelper frustum, boolean hasForcedFrustum, int frame, boolean spectator, CallbackInfo ci) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            ShadowRenderer.visibleBlockEntities.addAll(this.chunkRenderManager.getVisibleBlockEntities());
        }
    }

    @Inject(method={"scheduleTerrainUpdate()V"}, remap=false, at={@At(value="INVOKE", target="me/jellysquid/mods/sodium/client/render/chunk/ChunkRenderManager.markDirty ()V", remap=false)})
    private void iris$ensureStateSwappedBeforeMarkDirty(CallbackInfo ci) {
        this.iris$ensureStateSwapped();
    }

    @Inject(method={"updateChunks"}, remap=false, at={@At(value="FIELD", target="me/jellysquid/mods/sodium/client/render/SodiumWorldRenderer.lastCameraX : D", ordinal=0, remap=false)})
    private void iris$ensureStateSwappedInUpdateChunks(ActiveRenderInfo camera, ClippingHelper frustum, boolean hasForcedFrustum, int frame, boolean spectator, CallbackInfo ci) {
        this.iris$ensureStateSwapped();
    }

    @Redirect(method={"updateChunks"}, remap=false, at=@At(value="FIELD", target="me/jellysquid/mods/sodium/client/render/SodiumWorldRenderer.lastCameraX : D", ordinal=0, remap=false))
    private double iris$forceChunkGraphRebuildInShadowPass(SodiumWorldRenderer worldRenderer) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            return Double.NaN;
        }
        return this.lastCameraX;
    }

    @Inject(method={"drawChunkLayer"}, remap=false, at={@At(value="HEAD")})
    private void iris$beforeDrawChunkLayer(RenderType renderType, MatrixStack poseStack, double x, double y, double z, CallbackInfo ci) {
        this.iris$ensureStateSwapped();
    }
}

