/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ShaderPackSelectionList
extends IrisObjectSelectionList<BaseEntry> {
    private static final ITextComponent PACK_LIST_LABEL = new TranslationTextComponent("pack.iris.list.label").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY});
    private final TopButtonRowEntry topButtonRow = new TopButtonRowEntry(this, Iris.getIrisConfig().areShadersEnabled());
    private ShaderPackEntry applied = null;

    public ShaderPackSelectionList(Minecraft client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, left, right, 20);
        this.refresh();
    }

    public int func_230949_c_() {
        return Math.min(308, this.field_230670_d_ - 50);
    }

    protected int func_230962_i_(int index) {
        return super.func_230962_i_(index) + 2;
    }

    public void refresh() {
        Collection<String> names;
        this.func_230963_j_();
        try {
            names = Iris.getShaderpacksDirectoryManager().enumerate();
        }
        catch (Throwable e) {
            Iris.logger.error("Error reading files while constructing selection UI", e);
            this.addLabelEntries(new ITextComponent[]{StringTextComponent.field_240750_d_, new StringTextComponent("There was an error reading your shaderpacks directory").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}), StringTextComponent.field_240750_d_, new StringTextComponent("Check your logs for more information."), new StringTextComponent("Please file an issue report including a log file."), new StringTextComponent("If you are able to identify the file causing this, please include it in your report as well."), new StringTextComponent("Note that this might be an issue with folder permissions; ensure those are correct first.")});
            return;
        }
        this.func_230513_b_((AbstractList.AbstractListEntry)this.topButtonRow);
        this.topButtonRow.allowEnableShadersButton = names.size() > 0;
        int index = 0;
        for (String name : names) {
            this.addPackEntry(++index, name);
        }
        this.addLabelEntries(PACK_LIST_LABEL);
    }

    public void addPackEntry(int index, String name) {
        ShaderPackEntry entry = new ShaderPackEntry(index, this, name);
        Iris.getIrisConfig().getShaderPackName().ifPresent(currentPackName -> {
            if (name.equals(currentPackName)) {
                this.func_241215_a_((AbstractList.AbstractListEntry)entry);
                this.setApplied(entry);
            }
        });
        this.func_230513_b_((AbstractList.AbstractListEntry)entry);
    }

    public void addLabelEntries(ITextComponent ... lines) {
        for (ITextComponent text : lines) {
            this.func_230513_b_((AbstractList.AbstractListEntry)new LabelEntry(text));
        }
    }

    public void select(String name) {
        for (int i = 0; i < this.func_230965_k_(); ++i) {
            BaseEntry entry = (BaseEntry)this.func_230953_d_(i);
            if (!(entry instanceof ShaderPackEntry) || !((ShaderPackEntry)entry).packName.equals(name)) continue;
            this.func_241215_a_((AbstractList.AbstractListEntry)entry);
            return;
        }
    }

    public void setApplied(ShaderPackEntry entry) {
        this.applied = entry;
    }

    public ShaderPackEntry getApplied() {
        return this.applied;
    }

    public TopButtonRowEntry getTopButtonRow() {
        return this.topButtonRow;
    }

    public static class ShaderPackEntry
    extends BaseEntry {
        private final String packName;
        private final ShaderPackSelectionList list;
        private final int index;

        public ShaderPackEntry(int index, ShaderPackSelectionList list, String packName) {
            this.packName = packName;
            this.list = list;
            this.index = index;
        }

        public boolean isApplied() {
            return this.list.getApplied() == this;
        }

        public boolean isSelected() {
            return this.list.func_230958_g_() == this;
        }

        public String getPackName() {
            return this.packName;
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int color = 0xFFFFFF;
            String name = this.packName;
            boolean shadersEnabled = this.list.getTopButtonRow().shadersEnabled;
            if (font.func_238414_a_((ITextProperties)new StringTextComponent(name).func_240699_a_(TextFormatting.BOLD)) > this.list.func_230949_c_() - 3) {
                name = font.func_238412_a_(name, this.list.func_230949_c_() - 8) + "...";
            }
            StringTextComponent text = new StringTextComponent(name);
            if (shadersEnabled && this.func_231047_b_(mouseX, mouseY)) {
                text = text.func_240699_a_(TextFormatting.BOLD);
            }
            if (this.isApplied()) {
                color = 16773731;
            }
            if (!shadersEnabled) {
                color = 0xA2A2A2;
            }
            AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)font, (ITextComponent)text, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)color);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.list.getTopButtonRow().shadersEnabled && !this.isSelected() && button == 0) {
                this.list.select(this.index);
                return true;
            }
            return false;
        }
    }

    public static class TopButtonRowEntry
    extends BaseEntry {
        private static final ITextComponent REFRESH_SHADER_PACKS_LABEL = new TranslationTextComponent("options.iris.refreshShaderPacks").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)10079999)));
        private static final ITextComponent NONE_PRESENT_LABEL = new TranslationTextComponent("options.iris.shaders.nonePresent").func_240699_a_(TextFormatting.GRAY);
        private static final ITextComponent SHADERS_DISABLED_LABEL = new TranslationTextComponent("options.iris.shaders.disabled");
        private static final ITextComponent SHADERS_ENABLED_LABEL = new TranslationTextComponent("options.iris.shaders.enabled");
        private static final int REFRESH_BUTTON_WIDTH = 18;
        private final ShaderPackSelectionList list;
        private final IrisElementRow buttons = new IrisElementRow();
        private final EnableShadersButtonElement enableDisableButton;
        private final IrisElementRow.Element refreshPacksButton;
        public boolean allowEnableShadersButton = true;
        public boolean shadersEnabled;

        public TopButtonRowEntry(ShaderPackSelectionList list, boolean shadersEnabled) {
            this.list = list;
            this.shadersEnabled = shadersEnabled;
            this.enableDisableButton = new EnableShadersButtonElement(this.getEnableDisableLabel(), button -> {
                if (this.allowEnableShadersButton) {
                    this.shadersEnabled = !this.shadersEnabled;
                    button.text = this.getEnableDisableLabel();
                    GuiUtil.playButtonClickSound();
                    return true;
                }
                return false;
            });
            this.refreshPacksButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.REFRESH, button -> {
                this.list.refresh();
                GuiUtil.playButtonClickSound();
                return true;
            });
            this.buttons.add(this.enableDisableButton, 0).add(this.refreshPacksButton, 18);
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.setWidth(this.enableDisableButton, entryWidth - 1 - 18);
            this.enableDisableButton.centerX = x + (int)((double)entryWidth * 0.5);
            this.buttons.render(poseStack, x - 2, y - 3, 18, mouseX, mouseY, tickDelta, hovered);
            if (this.refreshPacksButton.isHovered()) {
                ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(Minecraft.func_71410_x().field_71466_p, poseStack, REFRESH_SHADER_PACKS_LABEL, mouseX - 8 - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)REFRESH_SHADER_PACKS_LABEL), mouseY - 16));
            }
        }

        private ITextComponent getEnableDisableLabel() {
            return this.allowEnableShadersButton ? (this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL) : NONE_PRESENT_LABEL;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            return this.buttons.mouseClicked(mouseX, mouseY, button);
        }

        public static class EnableShadersButtonElement
        extends IrisElementRow.TextButtonElement {
            private int centerX;

            public EnableShadersButtonElement(ITextComponent text, Function<IrisElementRow.TextButtonElement, Boolean> onClick) {
                super(text, onClick);
            }

            @Override
            public void renderLabel(MatrixStack poseStack, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
                int textX = this.centerX - (int)((double)this.font.func_238414_a_((ITextProperties)this.text) * 0.5);
                int textY = y + (int)((double)(height - 8) * 0.5);
                this.font.func_243246_a(poseStack, this.text, (float)textX, (float)textY, 0xFFFFFF);
            }
        }
    }

    public static class LabelEntry
    extends BaseEntry {
        private final ITextComponent label;

        public LabelEntry(ITextComponent label) {
            this.label = label;
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xC2C2C2);
        }
    }

    public static abstract class BaseEntry
    extends ExtendedList.AbstractListEntry<BaseEntry> {
        protected BaseEntry() {
        }
    }
}

