/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL;

public class CenterDepthSampler {
    private static final double LN2 = Math.log(2.0);
    private boolean hasFirstSample;
    private boolean everRetrieved;
    private final Program program;
    private final GlFramebuffer framebuffer;
    private final int texture = GlStateManager.func_227622_J_();
    private final int altTexture = GlStateManager.func_227622_J_();

    public CenterDepthSampler(float halfLife) {
        ProgramBuilder builder;
        this.framebuffer = new GlFramebuffer();
        InternalTextureFormat format = GL.getCapabilities().OpenGL30 ? InternalTextureFormat.R32F : InternalTextureFormat.RGB16;
        RenderSystem.bindTexture((int)this.texture);
        this.setupColorTexture(format);
        RenderSystem.bindTexture((int)this.altTexture);
        this.setupColorTexture(format);
        RenderSystem.bindTexture((int)0);
        this.framebuffer.addColorAttachment(0, this.texture);
        try {
            String fsh = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/centerDepth.fsh"))), StandardCharsets.UTF_8);
            String vsh = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/centerDepth.vsh"))), StandardCharsets.UTF_8);
            builder = ProgramBuilder.begin("centerDepthSmooth", vsh, null, fsh, (ImmutableSet<Integer>)ImmutableSet.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        builder.addDynamicSampler(() -> Minecraft.func_71410_x().func_147110_a().func_242997_g(), "depth");
        builder.addDynamicSampler(() -> this.altTexture, "altDepth");
        builder.uniform1f(UniformUpdateFrequency.PER_FRAME, "lastFrameTime", SystemTimeUniforms.TIMER::getLastFrameTime);
        builder.uniform1f(UniformUpdateFrequency.ONCE, "decay", () -> 1.0 / ((double)halfLife * 0.1 / LN2));
        this.program = builder.build();
    }

    public void sampleCenterDepth() {
        if (this.hasFirstSample && !this.everRetrieved) {
            return;
        }
        this.hasFirstSample = true;
        this.framebuffer.bind();
        this.program.use();
        RenderSystem.viewport((int)0, (int)0, (int)1, (int)1);
        FullScreenQuadRenderer.INSTANCE.render();
        GlStateManager.func_227723_g_((int)0);
        this.framebuffer.bind();
        GlStateManager.func_227760_t_((int)this.altTexture);
        DepthCopyStrategy.fastest(false).copy(this.framebuffer, this.texture, null, this.altTexture, 1, 1);
        GlStateManager.func_227760_t_((int)0);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    public void setupColorTexture(InternalTextureFormat format) {
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)format.getGlFormat(), (int)1, (int)1, (int)0, (int)format.getPixelFormat().getGlFormat(), (int)PixelType.FLOAT.getGlFormat(), null);
    }

    public int getCenterDepthTexture() {
        this.everRetrieved = true;
        return this.altTexture;
    }

    public void destroy() {
        GlStateManager.func_227758_s_((int)this.texture);
        GlStateManager.func_227758_s_((int)this.altTexture);
        this.framebuffer.destroy();
        this.program.destroy();
    }
}

