/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Objects;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.mixin.DimensionTypeAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;

public final class WorldTimeUniforms {
    private WorldTimeUniforms() {
    }

    public static void addWorldTimeUniforms(UniformHolder uniforms) {
        uniforms.uniform1i(UniformUpdateFrequency.PER_TICK, "worldTime", WorldTimeUniforms::getWorldDayTime).uniform1i(UniformUpdateFrequency.PER_TICK, "worldDay", WorldTimeUniforms::getWorldDay).uniform1i(UniformUpdateFrequency.PER_TICK, "moonPhase", () -> WorldTimeUniforms.getWorld().func_242414_af());
    }

    static int getWorldDayTime() {
        long timeOfDay = WorldTimeUniforms.getWorld().func_72820_D();
        long dayTime = ((DimensionTypeAccessor)WorldTimeUniforms.getWorld().func_230315_m_()).getFixedTime().orElse(timeOfDay % 24000L);
        return (int)dayTime;
    }

    private static int getWorldDay() {
        long timeOfDay = WorldTimeUniforms.getWorld().func_72820_D();
        long day = timeOfDay / 24000L;
        return (int)day;
    }

    private static ClientWorld getWorld() {
        return Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
    }
}

