/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import team.chisel.common.block.TileAutoChisel;

@ParametersAreNonnullByDefault
public class BlockAutoChisel
extends Block {
    private static final VoxelShape COLLISION_SHAPE = VoxelShapes.func_216384_a((VoxelShape)BlockAutoChisel.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockAutoChisel.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), BlockAutoChisel.func_208617_a((double)15.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), BlockAutoChisel.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), BlockAutoChisel.func_208617_a((double)0.0, (double)10.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), BlockAutoChisel.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape SELECTION_SHAPE = VoxelShapes.func_197868_b();

    public BlockAutoChisel(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(@Nullable BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nullable BlockState state, @Nullable IBlockReader world) {
        return new TileAutoChisel();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof TileAutoChisel) {
            player.func_213829_a((INamedContainerProvider)tileentity);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileAutoChisel) {
            ((TileAutoChisel)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileAutoChisel) {
            TileAutoChisel autochisel = (TileAutoChisel)tileentity;
            this.dumpItems(worldIn, pos, autochisel.getInputInv());
            this.dumpItems(worldIn, pos, autochisel.getOtherInv());
            this.dumpItems(worldIn, pos, autochisel.getOutputInv());
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dumpItems(World worldIn, BlockPos pos, IItemHandler inv) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SELECTION_SHAPE;
    }
}

