/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import team.chisel.Chisel;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IVariationRegistry;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.inventory.SlotChiselSelection;
import team.chisel.common.util.NBTUtil;
import team.chisel.common.util.SoundUtil;

@ParametersAreNonnullByDefault
public class ChiselContainer
extends Container {
    protected final InventoryChiselSelection inventoryChisel;
    protected final PlayerInventory inventoryPlayer;
    protected final Hand hand;
    protected final int chiselSlot;
    protected final ItemStack chisel;
    protected final IVariationRegistry carving;
    protected Slot inputSlot;
    ClickType currentClickType;

    public ChiselContainer(ContainerType<? extends ChiselContainer> type, int windowId, PlayerInventory inventoryplayer) {
        this(type, windowId, inventoryplayer, new InventoryChiselSelection(ItemStack.field_190927_a, 60), Hand.MAIN_HAND);
    }

    public ChiselContainer(ContainerType<? extends ChiselContainer> type, int windowId, PlayerInventory inventoryplayer, InventoryChiselSelection inv, Hand hand) {
        super(type, windowId);
        this.inventoryChisel = inv;
        this.inventoryPlayer = inventoryplayer;
        this.hand = hand;
        this.chiselSlot = hand == Hand.MAIN_HAND ? inventoryplayer.field_70461_c : inventoryplayer.func_70302_i_() - 1;
        this.chisel = inventoryplayer.func_70301_a(this.chiselSlot);
        this.carving = CarvingUtils.getChiselRegistry();
        inv.container = this;
        this.addSlots();
        if (!this.chisel.func_190926_b() && this.chisel.func_77942_o()) {
            ItemStack stack = NBTUtil.getChiselTarget(this.chisel);
            this.inventoryChisel.func_70299_a(this.getInventoryChisel().size, stack);
        }
        this.inventoryChisel.updateItems();
    }

    protected void addSlots() {
        int i;
        int top = 8;
        int left = 62;
        for (i = 0; i < this.getInventoryChisel().size; ++i) {
            this.func_75146_a(new SlotChiselSelection(this, this.inventoryChisel, this.inventoryChisel, i, left + i % 10 * 18, top + i / 10 * 18));
        }
        this.inputSlot = new SlotChiselInput(this, this.inventoryChisel, this.getInventoryChisel().size, 24, 24);
        this.func_75146_a(this.inputSlot);
        top += 112;
        left += 9;
        for (i = 0; i < 27; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i + 9, left + i % 9 * 18, top + i / 9 * 18));
        }
        top += 58;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i, left + i % 9 * 18, top + i / 9 * 18));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (clickTypeIn != ClickType.QUICK_CRAFT && slotId >= 0) {
            int clickedSlot = slotId - this.inventoryChisel.func_70302_i_() - 27;
            Chisel.debug("Slot clicked is " + slotId + " and slot length is " + this.field_75151_b.size());
            try {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                Chisel.debug("Slot is " + slot);
            }
            catch (Exception exception) {
                Chisel.debug("Exception getting slot");
                exception.printStackTrace();
            }
            if (clickedSlot == this.chiselSlot || clickTypeIn == ClickType.SWAP) {
                return ItemStack.field_190927_a;
            }
        }
        this.currentClickType = clickTypeIn;
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(PlayerEntity entityplayer) {
        this.inventoryChisel.clearItems();
        super.func_75134_a(entityplayer);
    }

    public boolean func_75145_c(PlayerEntity entityplayer) {
        return this.inventoryChisel.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(PlayerEntity entity, int slotIdx) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIdx);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotIdx > this.getInventoryChisel().size) {
                if (!this.func_75135_a(itemstack1, this.getInventoryChisel().size, this.getInventoryChisel().size + 1, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (slotIdx < this.getInventoryChisel().size && !itemstack1.func_190926_b()) {
                SlotChiselSelection selectslot = (SlotChiselSelection)slot;
                ItemStack check = SlotChiselSelection.craft(this, entity, itemstack1, true);
                if (check.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(check, this.getInventoryChisel().size + 1, this.getInventoryChisel().size + 1 + 36, true)) {
                    return ItemStack.field_190927_a;
                }
                SoundUtil.playSound(entity, this.getChisel(), itemstack1);
                itemstack1 = SlotChiselSelection.craft(this, entity, itemstack1, false);
                itemstack1.func_190918_g(check.func_190916_E());
                this.getInventoryChisel().setStackInSpecialSlot(check);
            } else if (!this.func_75135_a(itemstack1, this.getInventoryChisel().size + 1, this.getInventoryChisel().size + 1 + 36, true)) {
                return ItemStack.field_190927_a;
            }
            boolean clearSlot = slotIdx >= this.getInventoryChisel().size || this.getInventoryChisel().getStackInSpecialSlot().func_190926_b();
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.func_190926_b()) {
                if (clearSlot) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            } else {
                slot.func_75218_e();
            }
            this.getInventoryChisel().updateItems();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            if (slotIdx >= this.getInventoryChisel().size) {
                slot.func_190901_a(entity, itemstack1);
            }
            if (itemstack1.func_190926_b()) {
                if (clearSlot) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
                return ItemStack.field_190927_a;
            }
            if (!clearSlot) {
                slot.func_75215_d(itemstack1);
            }
            return itemstack1;
        }
        return itemstack;
    }

    public void onChiselSlotChanged() {
        NBTUtil.setChiselTarget(this.chisel, this.inventoryChisel.getStackInSpecialSlot());
    }

    public void onChiselBroken() {
        if (!this.getInventoryPlayer().field_70458_d.field_70170_p.field_72995_K) {
            this.getInventoryPlayer().field_70458_d.func_71019_a(this.inventoryChisel.getStackInSpecialSlot(), false);
            this.inventoryChisel.setStackInSpecialSlot(ItemStack.field_190927_a);
        }
    }

    public InventoryChiselSelection getInventoryChisel() {
        return this.inventoryChisel;
    }

    public PlayerInventory getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    public Hand getHand() {
        return this.hand;
    }

    public int getChiselSlot() {
        return this.chiselSlot;
    }

    public ItemStack getChisel() {
        return this.chisel;
    }

    public IVariationRegistry getCarving() {
        return this.carving;
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public ClickType getCurrentClickType() {
        return this.currentClickType;
    }
}

