/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import team.chisel.api.IChiselGuiType;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.api.carving.IChiselMode;
import team.chisel.client.util.ChiselLangKeys;
import team.chisel.common.config.Configurations;
import team.chisel.common.item.ChiselMode;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class ItemChisel
extends Item
implements IChiselItem {
    private final ChiselType type;

    public ItemChisel(ChiselType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public int getMaxDamage(ItemStack stack) {
        if (Configurations.allowChiselDamage) {
            return this.type.maxDamage;
        }
        return 0;
    }

    public boolean func_77645_m() {
        return Configurations.allowChiselDamage;
    }

    public boolean func_82789_a(ItemStack damagedItem, ItemStack repairMaterial) {
        switch (this.type) {
            case DIAMOND: 
            case HITECH: {
                return repairMaterial.func_77973_b().equals(Items.field_151045_i);
            }
            case IRON: {
                return repairMaterial.func_77973_b().equals(Items.field_151042_j);
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add((ITextComponent)ChiselLangKeys.TT_CHISEL_GUI.format(TextFormatting.AQUA, TextFormatting.GRAY));
        if (this.type != ChiselType.IRON || Configurations.ironChiselCanLeftClick) {
            list.add((ITextComponent)ChiselLangKeys.TT_CHISEL_LC1.format(TextFormatting.AQUA, TextFormatting.GRAY));
            list.add((ITextComponent)ChiselLangKeys.TT_CHISEL_LC2.format(TextFormatting.AQUA, TextFormatting.GRAY));
        }
        if (this.type != ChiselType.IRON || Configurations.ironChiselHasModes) {
            list.add((ITextComponent)new StringTextComponent(""));
            list.add((ITextComponent)ChiselLangKeys.TT_CHISEL_MODES.getComponent());
            list.add((ITextComponent)ChiselLangKeys.TT_CHISEL_SELECTED_MODE.format(TextFormatting.GREEN, new TranslationTextComponent(NBTUtil.getChiselMode(stack).getUnlocName() + ".name")));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Chisel Damage", (double)this.type.attackDamage, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p -> p.func_213334_d(Hand.MAIN_HAND));
        return super.func_77644_a(stack, attacker, target);
    }

    @Override
    public boolean canOpenGui(World world, PlayerEntity player, Hand hand) {
        return true;
    }

    @Override
    public IChiselGuiType getGuiType(World world, PlayerEntity player, Hand hand) {
        return this.type == ChiselType.HITECH ? IChiselGuiType.ChiselGuiType.HITECH : IChiselGuiType.ChiselGuiType.NORMAL;
    }

    @Override
    public boolean canChisel(World world, PlayerEntity player, ItemStack chisel, ICarvingVariation target) {
        return !chisel.func_190926_b();
    }

    @Override
    public boolean onChisel(World world, PlayerEntity player, ItemStack chisel, ICarvingVariation target) {
        return Configurations.allowChiselDamage;
    }

    @Override
    public boolean canChiselBlock(World world, PlayerEntity player, Hand hand, BlockPos pos, BlockState state) {
        return this.type == ChiselType.HITECH || this.type == ChiselType.DIAMOND || Configurations.ironChiselCanLeftClick;
    }

    @Override
    public boolean supportsMode(PlayerEntity player, ItemStack chisel, IChiselMode mode) {
        return this.type == ChiselType.HITECH || (this.type == ChiselType.DIAMOND || Configurations.ironChiselHasModes) && mode != ChiselMode.CONTIGUOUS && mode != ChiselMode.CONTIGUOUS_2D;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public ChiselType getType() {
        return this.type;
    }

    public static enum ChiselType {
        IRON(Configurations.ironChiselMaxDamage, Configurations.ironChiselAttackDamage),
        DIAMOND(Configurations.diamondChiselMaxDamage, Configurations.diamondChiselAttackDamage),
        HITECH(Configurations.hitechChiselMaxDamage, Configurations.hitechChiselAttackDamage);

        final int maxDamage;
        final int attackDamage;

        private ChiselType(int maxDamage, int attackDamage) {
            this.maxDamage = maxDamage;
            this.attackDamage = attackDamage;
        }
    }
}

