/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public final class BlockUtil {
    public static boolean isBlockInWater(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!world.func_204610_c(pos.func_177972_a(direction)).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlace(World world, PlayerEntity player, BlockPos pos, BlockState state) {
        ISelectionContext selectionContext = player == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)player);
        VoxelShape voxelshape = state.func_215685_b((IBlockReader)world, pos, selectionContext);
        VoxelShape offsetShape = world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos);
        return (offsetShape.func_197766_b() || world.func_180495_p(pos).func_185904_a().func_76222_j()) && state.func_196955_c((IWorldReader)world, pos) && world.func_195585_a(null, voxelshape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public static SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    public static boolean isPosNotTouchingBlock(IWorld world, BlockPos pos, Block blockToCheck, Direction ... blacklistedDirections) {
        for (Direction directions : Direction.values()) {
            List<Direction> blacklistedDirectionsList = Arrays.asList(blacklistedDirections);
            if (blacklistedDirectionsList.contains(directions) || world.func_180495_p(pos.func_177972_a(directions)).func_177230_c() != blockToCheck) continue;
            return false;
        }
        return true;
    }

    public static BlockState transferAllBlockStates(BlockState initial, BlockState after) {
        BlockState block = after;
        for (Property property : initial.func_177230_c().func_176194_O().func_177623_d()) {
            if (!after.func_235901_b_(property) || initial.func_177229_b(property) == null) continue;
            block = (BlockState)block.func_206870_a(property, initial.func_177229_b(property));
        }
        return block;
    }

    public static AxisAlignedBB rotateHorizontalBB(AxisAlignedBB bb, BBRotation rotation) {
        AxisAlignedBB newBB = bb;
        return rotation.rotateBB(newBB);
    }

    public static BlockPos offsetPos(IBlockSource source) {
        return source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DirectionalBlock.field_176387_N));
    }

    public static BlockState getStateAtOffsetPos(IBlockSource source) {
        return source.func_197524_h().func_180495_p(BlockUtil.offsetPos(source));
    }

    public static <T extends Entity> List<T> getEntitiesAtOffsetPos(IBlockSource source, Class<? extends T> entityType) {
        return source.func_197524_h().func_217357_a(entityType, new AxisAlignedBB(BlockUtil.offsetPos(source)));
    }

    public static <T extends Entity> List<T> getEntitiesAtOffsetPos(IBlockSource source, Class<? extends T> entityType, Predicate<? super T> predicate) {
        return source.func_197524_h().func_175647_a(entityType, new AxisAlignedBB(BlockUtil.offsetPos(source)), predicate);
    }

    public static enum BBRotation {
        REVERSE_X(bb -> {
            float minX = 1.0f - (float)bb.field_72336_d;
            return new AxisAlignedBB((double)minX, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d >= 1.0 ? bb.field_72336_d - bb.field_72340_a : bb.field_72336_d + (double)minX, bb.field_72337_e, bb.field_72334_f);
        }),
        REVERSE_Z(bb -> {
            float minZ = 1.0f - (float)bb.field_72334_f;
            return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, (double)minZ, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f >= 1.0 ? bb.field_72334_f - bb.field_72339_c : bb.field_72334_f + (double)minZ);
        }),
        RIGHT(bb -> new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, bb.field_72334_f, bb.field_72337_e, bb.field_72336_d)),
        LEFT(bb -> REVERSE_X.rotateBB(RIGHT.rotateBB((AxisAlignedBB)bb)));

        private final UnaryOperator<AxisAlignedBB> modifier;

        private BBRotation(UnaryOperator<AxisAlignedBB> modifier) {
            this.modifier = modifier;
        }

        public AxisAlignedBB rotateBB(AxisAlignedBB bb) {
            return (AxisAlignedBB)this.modifier.apply(bb);
        }

        public static BBRotation getRotationForDirection(Direction currentDirection, Direction startingDirection) {
            int currentIndex = currentDirection.func_176745_a() - 2;
            int startingIndex = startingDirection.func_176745_a() - 2;
            int index = (currentIndex - startingIndex) % 4;
            switch (index) {
                default: {
                    return REVERSE_X;
                }
                case 1: {
                    return REVERSE_Z;
                }
                case 2: {
                    return RIGHT;
                }
                case 3: 
            }
            return LEFT;
        }
    }
}

