/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class GenerationPiece {
    private final List<BlockPart> blockPieces = Lists.newArrayList();
    private final BiPredicate<IWorld, BlockPart> blockPlaceCondition;

    public GenerationPiece(BiPredicate<IWorld, BlockPart> blockPlaceCondition) {
        this.blockPlaceCondition = blockPlaceCondition;
    }

    public void addBlockPiece(BlockState state, BlockPos pos) {
        this.blockPieces.add(new BlockPart(state, pos));
    }

    public boolean canPlace(IWorld world) {
        for (BlockPart blocks : this.blockPieces) {
            if (this.blockPlaceCondition.test(world, blocks)) continue;
            return false;
        }
        return true;
    }

    public void place(IWorld world) {
        for (BlockPart blocks : this.blockPieces) {
            world.func_180501_a(blocks.pos, blocks.state, 2);
        }
    }

    public void tryToPlace(IWorld world) {
        if (this.canPlace(world)) {
            this.place(world);
        }
    }

    public class BlockPart {
        public final BlockState state;
        public final BlockPos pos;

        public BlockPart(BlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

