/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridSetAutoRefill;

public class TerminalButtonItemStackCraftingGridAutoRefill<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, TerminalStorageTabIngredientComponentItemStackCraftingCommon, ButtonImage> {
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private AutoRefillType active;

    public TerminalButtonItemStackCraftingGridAutoRefill(TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.state = state;
        this.buttonName = "itemstack_grid_autorefill";
        this.clientTab = clientTab;
        this.reloadFromState();
        this.notifyServer((TerminalStorageTabIngredientComponentClient)clientTab);
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundNBT data = (CompoundNBT)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = AutoRefillType.values()[data.func_74762_e("active")];
        } else {
            this.active = AutoRefillType.STORAGE;
        }
    }

    protected void notifyServer(TerminalStorageTabIngredientComponentClient<T, ?> clientTab) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetAutoRefill(clientTab.getName().toString(), this.active));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ButtonImage createButton(int x, int y) {
        return new ButtonImage(x, y, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.craftinggrid.autorefill"), b -> {}, new IImage[]{this.active == AutoRefillType.DISABLED ? Images.BUTTON_BACKGROUND_INACTIVE : Images.BUTTON_BACKGROUND_ACTIVE, this.active.getImage()});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, TerminalStorageTabIngredientComponentItemStackCraftingCommon commomTab, ButtonImage guiButton, int channel, int mouseButton) {
        this.active = mouseButton == 0 ? AutoRefillType.values()[(this.active.ordinal() + 1) % AutoRefillType.values().length] : AutoRefillType.DISABLED;
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("active", this.active.ordinal());
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (INBT)data);
        this.notifyServer(clientTab);
    }

    @Override
    public String getTranslationKey() {
        return "gui.integratedterminals.terminal_storage.craftinggrid.autorefill";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(PlayerEntity player, ITooltipFlag tooltipFlag, List<ITextComponent> lines) {
        lines.add((ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.craftinggrid.autorefill.info"));
        lines.add((ITextComponent)new TranslationTextComponent(this.active.getLabel()));
    }

    public static enum AutoRefillType {
        DISABLED((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_DISABLED, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.disabled"),
        STORAGE((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_STORAGE, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.storage"),
        PLAYER((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_PLAYER, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.player"),
        STORAGE_PLAYER((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_STORAGEPLAYER, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.storage_player"),
        PLAYER_STORAGE((IImage)Images.BUTTON_MIDDLE_AUTOREFILL_PLAYERSTORAGE, "gui.integratedterminals.terminal_storage.craftinggrid.autorefill.type.player_storage");

        @Nullable
        private final IImage image;
        private final String label;

        private AutoRefillType(IImage image, String label) {
            this.image = image;
            this.label = label;
        }

        @Nullable
        public IImage getImage() {
            return this.image;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

