/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.button;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.client.gui.ButtonSort;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class TerminalButtonSort<T>
implements ITerminalButton<TerminalStorageTabIngredientComponentClient<T, ?>, ITerminalStorageTabCommon, ButtonSort> {
    private final IIngredientInstanceSorter<T> instanceSorter;
    private final TerminalStorageState state;
    private final String buttonName;
    private final ITerminalStorageTabClient<?> clientTab;
    private Comparator<T> effectiveSorter;
    private boolean active;
    private boolean descending;

    public TerminalButtonSort(IIngredientInstanceSorter<T> instanceSorter, TerminalStorageState state, ITerminalStorageTabClient<?> clientTab) {
        this.instanceSorter = instanceSorter;
        this.state = state;
        this.buttonName = "sort_" + instanceSorter.getTranslationKey();
        this.clientTab = clientTab;
        this.reloadFromState();
    }

    @Override
    public void reloadFromState() {
        if (this.state.hasButton(this.clientTab.getTabSettingsName().toString(), this.buttonName)) {
            CompoundNBT data = (CompoundNBT)this.state.getButton(this.clientTab.getTabSettingsName().toString(), this.buttonName);
            this.active = data.func_74767_n("active");
            this.descending = data.func_74767_n("descending");
        } else {
            this.active = false;
            this.descending = true;
        }
        this.updateSorter();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ButtonSort createButton(int x, int y) {
        return new ButtonSort(x, y, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.sort"), b -> {}, this.instanceSorter.getIcon(), this.active, this.descending);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(TerminalStorageTabIngredientComponentClient<T, ?> clientTab, ITerminalStorageTabCommon commonTab, ButtonSort guiButton, int channel, int mouseButton) {
        if (mouseButton == 0) {
            if (this.active) {
                if (this.descending) {
                    this.descending = false;
                } else {
                    this.active = false;
                }
            } else {
                this.active = true;
                this.descending = true;
            }
        } else {
            this.active = false;
            this.descending = true;
        }
        CompoundNBT data = new CompoundNBT();
        data.func_74757_a("active", this.active);
        data.func_74757_a("descending", this.descending);
        this.state.setButton(clientTab.getTabSettingsName().toString(), this.buttonName, (INBT)data);
        this.updateSorter();
        clientTab.resetFilteredIngredientsViews(channel);
    }

    protected void updateSorter() {
        this.effectiveSorter = this.active ? (this.descending ? this.instanceSorter.reversed() : this.instanceSorter) : null;
    }

    @Override
    public String getTranslationKey() {
        return this.instanceSorter.getTranslationKey();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(PlayerEntity player, ITooltipFlag tooltipFlag, List<ITextComponent> lines) {
        this.instanceSorter.getTooltip(player, tooltipFlag, lines);
        if (this.active) {
            lines.add((ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_storage.sort.order.label", new Object[]{new TranslationTextComponent(this.descending ? "gui.integratedterminals.terminal_storage.sort.order.descending" : "gui.integratedterminals.terminal_storage.sort.order.ascending")}).func_240699_a_(TextFormatting.ITALIC));
        } else {
            lines.add((ITextComponent)new TranslationTextComponent("general.cyclopscore.info.disabled").func_240699_a_(TextFormatting.ITALIC));
        }
    }

    @Nullable
    public Comparator<T> getEffectiveSorter() {
        return this.effectiveSorter;
    }
}

