/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.location;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountPart;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanPart;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientPartOpenPacket;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;
import org.cyclops.integratedterminals.part.PartTypes;

public class TerminalStorageLocationPart
implements ITerminalStorageLocation<PartPos> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integratedterminals", "part");
    }

    @Override
    public <T, M> void openContainerFromClient(CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData) {
        PartPos partPos = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientPartOpenPacket.send(partPos.getPos().getBlockPos(), partPos.getSide(), craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerFromServer(CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData, World world, ServerPlayerEntity player) {
        PartPos partPos = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientPartOpenPacket.openServer(world, partPos.getPos().getBlockPos(), partPos.getSide(), player, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerCraftingPlan(final CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData, final World world, ServerPlayerEntity player) {
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                PartPos location = (PartPos)craftingOptionGuiData.getLocationInstance();
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)PartPos.of((World)world, (BlockPos)location.getPos().getBlockPos(), (Direction)location.getSide()));
                return new ContainerTerminalStorageCraftingPlanPart(id, playerInventory, Optional.of(data.getRight()), Optional.of(data.getLeft()), (PartTypeTerminalStorage)((Object)data.getMiddle()), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            packetBuffer.func_180714_a(PartTypes.TERMINAL_STORAGE.getUniqueName().toString());
            craftingOptionGuiData.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    @Override
    public <T, M> void openContainerCraftingOptionAmount(final CraftingOptionGuiData<T, M, PartPos> craftingOptionGuiData, final World world, ServerPlayerEntity player) {
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                PartPos location = (PartPos)craftingOptionGuiData.getLocationInstance();
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)PartPos.of((World)world, (BlockPos)location.getPos().getBlockPos(), (Direction)location.getSide()));
                return new ContainerTerminalStorageCraftingOptionAmountPart(id, playerInventory, Optional.of(data.getRight()), Optional.of(data.getLeft()), (PartTypeTerminalStorage)((Object)data.getMiddle()), craftingOptionGuiData);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            packetBuffer.func_180714_a(PartTypes.TERMINAL_STORAGE.getUniqueName().toString());
            craftingOptionGuiData.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    @Override
    public void writeToPacketBuffer(PacketBuffer packetBuffer, PartPos location) {
        PacketCodec.getAction(PartPos.class).encode((Object)location, packetBuffer);
    }

    @Override
    public PartPos readFromPacketBuffer(PacketBuffer packetBuffer) {
        return (PartPos)PacketCodec.getAction(PartPos.class).decode(packetBuffer);
    }
}

