/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.part;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.core.part.PartTypeTerminal;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobs;

public class PartTypeTerminalCraftingJob
extends PartTypeTerminal<PartTypeTerminalCraftingJob, PartStateEmpty<PartTypeTerminalCraftingJob>> {
    public PartTypeTerminalCraftingJob(String name) {
        super(name);
    }

    public int getConsumptionRate(PartStateEmpty<PartTypeTerminalCraftingJob> state) {
        return GeneralConfig.terminalCraftingBaseConsumption;
    }

    protected PartStateEmpty<PartTypeTerminalCraftingJob> constructDefaultState() {
        return new PartStateEmpty<PartTypeTerminalCraftingJob>(){

            public int getUpdateInterval() {
                return 1;
            }
        };
    }

    public Optional<INamedContainerProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(PartTypeTerminalCraftingJob.this.getTranslationKey());
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerTerminalCraftingJobs(id, playerInventory, (PartTarget)data.getRight(), Optional.of(data.getLeft()), (PartTypeTerminalCraftingJob)((Object)data.getMiddle()));
            }
        });
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
        PacketCodec.write((PacketBuffer)packetBuffer, (Object)pos);
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    public void loadTooltip(ItemStack itemStack, List<ITextComponent> lines) {
        super.loadTooltip(itemStack, lines);
        if (TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers().isEmpty()) {
            lines.add((ITextComponent)new TranslationTextComponent("parttype.integratedterminals.terminal_crafting_job.tooltip.nohandlers").func_240699_a_(TextFormatting.GOLD));
        }
    }
}

