/*
 * Decompiled with CFR 0.152.
 */
package cofh.toolscomplement.init;

import cofh.core.item.ArmorItemCoFH;
import cofh.lib.item.ArmorMaterialCoFH;
import cofh.lib.item.ItemTierCoFH;
import cofh.lib.item.impl.AxeItemCoFH;
import cofh.lib.item.impl.ExcavatorItem;
import cofh.lib.item.impl.HammerItem;
import cofh.lib.item.impl.HoeItemCoFH;
import cofh.lib.item.impl.KnifeItem;
import cofh.lib.item.impl.PickaxeItemCoFH;
import cofh.lib.item.impl.ShovelItemCoFH;
import cofh.lib.item.impl.SickleItem;
import cofh.lib.item.impl.SwordItemCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.ItemTagsCoFH;
import cofh.toolscomplement.ToolsComplement;
import cofh.toolscomplement.init.TComFlags;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvents;

public class TComItems {
    public static final IItemTier TOOL_MATERIAL_COPPER = new ItemTierCoFH(1, 160, 4.5f, 1.5f, 9, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_COPPER));
    public static final IItemTier TOOL_MATERIAL_TIN = new ItemTierCoFH(0, 16, 13.0f, 0.0f, 18, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_TIN));
    public static final IItemTier TOOL_MATERIAL_LEAD = new ItemTierCoFH(1, 32, 12.0f, 1.0f, 16, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_LEAD));
    public static final IItemTier TOOL_MATERIAL_SILVER = new ItemTierCoFH(0, 24, 14.0f, 0.0f, 30, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_SILVER));
    public static final IItemTier TOOL_MATERIAL_NICKEL = new ItemTierCoFH(2, 225, 7.0f, 2.5f, 12, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_NICKEL));
    public static final IItemTier TOOL_MATERIAL_BRONZE = new ItemTierCoFH(2, 325, 5.5f, 2.0f, 16, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_BRONZE));
    public static final IItemTier TOOL_MATERIAL_ELECTRUM = new ItemTierCoFH(0, 96, 13.0f, 0.0f, 28, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_ELECTRUM));
    public static final IItemTier TOOL_MATERIAL_INVAR = new ItemTierCoFH(2, 300, 7.0f, 2.5f, 13, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_INVAR));
    public static final IItemTier TOOL_MATERIAL_CONSTANTAN = new ItemTierCoFH(1, 250, 5.5f, 2.0f, 10, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_CONSTANTAN));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_COPPER = new ArmorMaterialCoFH("tools_complement:copper", 7, new int[]{1, 3, 4, 1}, 11, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_COPPER));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_TIN = new ArmorMaterialCoFH("tools_complement:tin", 8, new int[]{1, 3, 4, 1}, 20, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_TIN));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_LEAD = new ArmorMaterialCoFH("tools_complement:lead", 12, new int[]{2, 4, 5, 2}, 18, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_LEAD));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_SILVER = new ArmorMaterialCoFH("tools_complement:silver", 6, new int[]{1, 3, 5, 2}, 32, SoundEvents.field_187722_q, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_SILVER));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_NICKEL = new ArmorMaterialCoFH("tools_complement:nickel", 14, new int[]{2, 5, 5, 2}, 14, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_NICKEL));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_BRONZE = new ArmorMaterialCoFH("tools_complement:bronze", 16, new int[]{2, 5, 6, 2}, 18, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_BRONZE));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_ELECTRUM = new ArmorMaterialCoFH("tools_complement:electrum", 7, new int[]{1, 3, 5, 2}, 30, SoundEvents.field_187722_q, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_ELECTRUM));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_INVAR = new ArmorMaterialCoFH("tools_complement:invar", 15, new int[]{2, 5, 7, 2}, 15, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_INVAR));
    public static final ArmorMaterialCoFH ARMOR_MATERIAL_CONSTANTAN = new ArmorMaterialCoFH("tools_complement:constantan", 8, new int[]{1, 4, 4, 2}, 12, SoundEvents.field_187725_r, 0.0f, 0.0f, () -> Ingredient.func_199805_a((ITag)ItemTagsCoFH.INGOTS_CONSTANTAN));

    private TComItems() {
    }

    public static void register() {
        ItemGroup combat = ItemGroup.field_78037_j;
        ItemGroup tools = ItemGroup.field_78040_i;
        TComItems.registerExtraToolSet("iron", (IItemTier)ItemTier.IRON, tools, combat);
        TComItems.registerExtraToolSet("gold", (IItemTier)ItemTier.GOLD, tools, combat);
        TComItems.registerExtraToolSet("diamond", (IItemTier)ItemTier.DIAMOND, tools, combat);
        TComItems.registerExtraToolSet("netherite", (IItemTier)ItemTier.NETHERITE, tools, combat);
        TComItems.registerFullToolSet("copper", TOOL_MATERIAL_COPPER, tools, combat);
        TComItems.registerFullToolSet("tin", TOOL_MATERIAL_TIN, tools, combat);
        TComItems.registerFullToolSet("lead", TOOL_MATERIAL_LEAD, tools, combat);
        TComItems.registerFullToolSet("silver", TOOL_MATERIAL_SILVER, tools, combat);
        TComItems.registerFullToolSet("nickel", TOOL_MATERIAL_NICKEL, tools, combat);
        TComItems.registerFullToolSet("bronze", TOOL_MATERIAL_BRONZE, tools, combat);
        TComItems.registerFullToolSet("electrum", TOOL_MATERIAL_ELECTRUM, tools, combat);
        TComItems.registerFullToolSet("invar", TOOL_MATERIAL_INVAR, tools, combat);
        TComItems.registerFullToolSet("constantan", TOOL_MATERIAL_CONSTANTAN, tools, combat);
        TComItems.registerArmorSet("copper", (IArmorMaterial)ARMOR_MATERIAL_COPPER, combat);
        TComItems.registerArmorSet("tin", (IArmorMaterial)ARMOR_MATERIAL_TIN, combat);
        TComItems.registerArmorSet("lead", (IArmorMaterial)ARMOR_MATERIAL_LEAD, combat);
        TComItems.registerArmorSet("silver", (IArmorMaterial)ARMOR_MATERIAL_SILVER, combat);
        TComItems.registerArmorSet("nickel", (IArmorMaterial)ARMOR_MATERIAL_NICKEL, combat);
        TComItems.registerArmorSet("bronze", (IArmorMaterial)ARMOR_MATERIAL_BRONZE, combat);
        TComItems.registerArmorSet("electrum", (IArmorMaterial)ARMOR_MATERIAL_ELECTRUM, combat);
        TComItems.registerArmorSet("invar", (IArmorMaterial)ARMOR_MATERIAL_INVAR, combat);
        TComItems.registerArmorSet("constantan", (IArmorMaterial)ARMOR_MATERIAL_CONSTANTAN, combat);
    }

    private static void registerFullToolSet(String prefix, IItemTier tier, ItemGroup toolGroup, ItemGroup combatGroup) {
        TComItems.registerStandardToolSet(prefix, tier, toolGroup, combatGroup);
        TComItems.registerExtraToolSet(prefix, tier, toolGroup, combatGroup);
    }

    private static void registerStandardToolSet(String prefix, IItemTier tier, ItemGroup toolGroup, ItemGroup combatGroup) {
        ToolsComplement.ITEMS.register(prefix + "_shovel", () -> new ShovelItemCoFH(tier, 1.5f, -3.0f, new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_pickaxe", () -> new PickaxeItemCoFH(tier, 1, -2.8f, new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_axe", () -> new AxeItemCoFH(tier, tier.func_200929_c() > 0.0f ? 8.0f - tier.func_200929_c() : 6.0f, MathHelper.clamp((float)(-3.7f + tier.func_200928_b() / 10.0f), (float)-3.2f, (float)-3.0f), new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_hoe", () -> new HoeItemCoFH(tier, -tier.func_200925_d(), Math.min(-3.0f + (float)tier.func_200925_d(), 0.0f), new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_sword", () -> new SwordItemCoFH(tier, 3, -2.4f, new Item.Properties().func_200916_a(combatGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
    }

    private static void registerExtraToolSet(String prefix, IItemTier tier, ItemGroup toolGroup, ItemGroup combatGroup) {
        ToolsComplement.ITEMS.register(prefix + "_excavator", () -> new ExcavatorItem(tier, new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_hammer", () -> new HammerItem(tier, new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_sickle", () -> new SickleItem(tier, new Item.Properties().func_200916_a(toolGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
        ToolsComplement.ITEMS.register(prefix + "_knife", () -> new KnifeItem(tier, new Item.Properties().func_200916_a(combatGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_tools")));
    }

    private static void registerArmorSet(String prefix, IArmorMaterial material, ItemGroup armorGroup) {
        ToolsComplement.ITEMS.register(prefix + "_helmet", () -> new ArmorItemCoFH(material, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
        ToolsComplement.ITEMS.register(prefix + "_chestplate", () -> new ArmorItemCoFH(material, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
        ToolsComplement.ITEMS.register(prefix + "_leggings", () -> new ArmorItemCoFH(material, EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
        ToolsComplement.ITEMS.register(prefix + "_boots", () -> new ArmorItemCoFH(material, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(armorGroup)).setDisplayGroup(() -> ToolsComplement.itemGroup).setShowInGroups(TComFlags.getFlag(prefix + "_armor")));
    }
}

