/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.datagen.recipes.AbstractRecipeGenerator;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.fluid.ReactantFluid;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class FluidizerRecipeGenerator
extends AbstractRecipeGenerator {
    public FluidizerRecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Extreme Reactors 2Fluidizer recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> c) {
        FluidizerRecipeGenerator.solid(c, "yellorium", Content.Items.YELLORIUM_INGOT, Content.Fluids.YELLORIUM_SOURCE);
        FluidizerRecipeGenerator.solid(c, "yellorium9", Content.Items.YELLORIUM_BLOCK, Content.Fluids.YELLORIUM_SOURCE, 9);
        FluidizerRecipeGenerator.solid(c, "cyanite", Content.Items.CYANITE_INGOT, Content.Fluids.CYANITE_SOURCE);
        FluidizerRecipeGenerator.solid(c, "cyanite9", Content.Items.CYANITE_BLOCK, Content.Fluids.CYANITE_SOURCE, 9);
        FluidizerRecipeGenerator.solid(c, "blutonium", Content.Items.BLUTONIUM_INGOT, Content.Fluids.BLUTONIUM_SOURCE);
        FluidizerRecipeGenerator.solid(c, "blutonium9", Content.Items.BLUTONIUM_BLOCK, Content.Fluids.BLUTONIUM_SOURCE, 9);
        FluidizerRecipeGenerator.solid(c, "magentite", Content.Items.MAGENTITE_INGOT, Content.Fluids.MAGENTITE_SOURCE);
        FluidizerRecipeGenerator.solid(c, "magentite9", Content.Items.MAGENTITE_BLOCK, Content.Fluids.MAGENTITE_SOURCE, 9);
        FluidizerRecipeGenerator.solidMixing(c, "verderium", Content.Items.YELLORIUM_INGOT, 2, Content.Items.BLUTONIUM_INGOT, 1, Content.Fluids.VERDERIUM_SOURCE, 2);
        FluidizerRecipeGenerator.solidMixing(c, "verderium9", Content.Items.YELLORIUM_BLOCK, 2, Content.Items.BLUTONIUM_BLOCK, 1, Content.Fluids.VERDERIUM_SOURCE, 18);
        FluidizerRecipeGenerator.fluidMixing(c, "verderium", Content.Fluids.YELLORIUM_SOURCE, 2000, Content.Fluids.BLUTONIUM_SOURCE, 1000, Content.Fluids.VERDERIUM_SOURCE, 2000);
        FluidizerRecipeGenerator.solidMixing(c, "cryomisi", Items.field_151137_ax, 1, Items.field_221772_cv, 1, (Fluid)Content.Fluids.CRYOMISI_SOURCE.get(), 500);
        FluidizerRecipeGenerator.solidMixing(c, "tangerium", (Item)Content.Items.ANGLESITE_CRYSTAL.get(), 1, Items.field_151079_bi, 4, (Fluid)Content.Fluids.TANGERIUM_SOURCE.get(), 500);
        FluidizerRecipeGenerator.fluidMixing(c, "redfrigium", Content.Fluids.CRYOMISI_SOURCE, 1000, Content.Fluids.TANGERIUM_SOURCE, 1000, Content.Fluids.REDFRIGIUM_SOURCE, 2000);
        this.casing(c);
        this.glass(c);
        this.controller(c);
        this.port(c, "solidinjector", (Supplier<? extends IItemProvider>)Content.Items.FLUIDIZER_SOLIDINJECTOR, (IItemProvider)Items.field_221670_aw, (ITag<Item>)ContentTags.Items.INGOTS_YELLORIUM, (ITag<Item>)Tags.Items.DUSTS_REDSTONE);
        this.port(c, "fluidinjector", (Supplier<? extends IItemProvider>)Content.Items.FLUIDIZER_FLUIDINJECTOR, (IItemProvider)Items.field_221602_aD, (ITag<Item>)Tags.Items.INGOTS_NETHERITE, (ITag<Item>)Tags.Items.GEMS_LAPIS);
        this.port(c, "outputport", (Supplier<? extends IItemProvider>)Content.Items.FLUIDIZER_OUTPUTPORT, (IItemProvider)Items.field_221656_ap, (ITag<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, (ITag<Item>)Tags.Items.CHESTS);
        this.port(c, "powerport", (Supplier<? extends IItemProvider>)Content.Items.FLUIDIZER_POWERPORT, (IItemProvider)Items.field_222027_iT, (ITag<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, (ITag<Item>)Tags.Items.GEMS_DIAMOND);
    }

    private static void solid(Consumer<IFinishedRecipe> c, String name, Supplier<? extends Item> ingredient, Supplier<ReactantFluid.Source> result) {
        FluidizerRecipeGenerator.solid(c, name, ingredient, result, 1);
    }

    private static void solid(Consumer<IFinishedRecipe> c, String name, Supplier<? extends Item> ingredient, Supplier<ReactantFluid.Source> result, int resultMultiplier) {
        FluidizerRecipeGenerator.solid(c, name, ingredient.get(), 1, (Fluid)result.get(), 1000 * resultMultiplier);
    }

    private static void solid(Consumer<IFinishedRecipe> c, String name, Item ingredient, int ingredientAmount, Fluid result, int resultAmount) {
        FluidizerSolidRecipe.builder((IRecipeIngredient<ItemStack>)ItemStackRecipeIngredient.from((IItemProvider)ingredient, (int)ingredientAmount), (IRecipeResult<FluidStack>)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount))).build(c, ExtremeReactors.newID("fluidizer/solid/" + name));
    }

    private static void solidMixing(Consumer<IFinishedRecipe> c, String name, Supplier<? extends Item> ingredient1, int ingredient1Amount, Supplier<? extends Item> ingredient2, int ingredient2Amount, Supplier<ReactantFluid.Source> result, int resultMultiplier) {
        FluidizerRecipeGenerator.solidMixing(c, name, ingredient1.get(), ingredient1Amount, ingredient2.get(), ingredient2Amount, (Fluid)result.get(), 1000 * resultMultiplier);
    }

    private static void solidMixing(Consumer<IFinishedRecipe> c, String name, Item ingredient1, int ingredient1Amount, Item ingredient2, int ingredient2Amount, Fluid result, int resultAmount) {
        FluidizerSolidMixingRecipe.builder((IRecipeIngredient<ItemStack>)ItemStackRecipeIngredient.from((IItemProvider)ingredient1, (int)ingredient1Amount), (IRecipeIngredient<ItemStack>)ItemStackRecipeIngredient.from((IItemProvider)ingredient2, (int)ingredient2Amount), (IRecipeResult<FluidStack>)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount))).build(c, ExtremeReactors.newID("fluidizer/solidmixing/" + name + "_1"));
        FluidizerSolidMixingRecipe.builder((IRecipeIngredient<ItemStack>)ItemStackRecipeIngredient.from((IItemProvider)ingredient2, (int)ingredient2Amount), (IRecipeIngredient<ItemStack>)ItemStackRecipeIngredient.from((IItemProvider)ingredient1, (int)ingredient1Amount), (IRecipeResult<FluidStack>)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount))).build(c, ExtremeReactors.newID("fluidizer/solidmixing/" + name + "_2"));
    }

    private static void fluidMixing(Consumer<IFinishedRecipe> c, String name, Supplier<? extends Fluid> ingredient1, int ingredient1Amount, Supplier<? extends Fluid> ingredient2, int ingredient2Amount, Supplier<? extends Fluid> result, int resultAmount) {
        FluidizerRecipeGenerator.fluidMixing(c, name, ingredient1.get(), ingredient1Amount, ingredient2.get(), ingredient2Amount, result.get(), resultAmount);
    }

    private static void fluidMixing(Consumer<IFinishedRecipe> c, String name, Fluid ingredient1, int ingredient1Amount, Fluid ingredient2, int ingredient2Amount, Fluid result, int resultAmount) {
        FluidizerFluidMixingRecipe.builder((IRecipeIngredient<FluidStack>)FluidStackRecipeIngredient.from((Fluid)ingredient1, (int)ingredient1Amount), (IRecipeIngredient<FluidStack>)FluidStackRecipeIngredient.from((Fluid)ingredient2, (int)ingredient2Amount), (IRecipeResult<FluidStack>)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount))).build(c, ExtremeReactors.newID("fluidizer/fluidmixing/" + name + "_1"));
        FluidizerFluidMixingRecipe.builder((IRecipeIngredient<FluidStack>)FluidStackRecipeIngredient.from((Fluid)ingredient2, (int)ingredient2Amount), (IRecipeIngredient<FluidStack>)FluidStackRecipeIngredient.from((Fluid)ingredient1, (int)ingredient1Amount), (IRecipeResult<FluidStack>)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount))).build(c, ExtremeReactors.newID("fluidizer/fluidmixing/" + name + "_2"));
    }

    private void casing(Consumer<IFinishedRecipe> c) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Content.Items.FLUIDIZER_CASING.get())).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_151131_as).func_200469_a(Character.valueOf('C'), ContentTags.Items.INGOTS_YELLORIUM).func_200472_a("ICI").func_200472_a("CWC").func_200472_a("ICI").func_200473_b("bigreactors:general").func_200465_a("has_item", (ICriterionInstance)FluidizerRecipeGenerator.func_200409_a(ContentTags.Items.INGOTS_YELLORIUM)).func_200467_a(c, FluidizerRecipeGenerator.fluidizerRecipeName("casing"));
    }

    private void glass(Consumer<IFinishedRecipe> c) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Content.Items.FLUIDIZER_GLASS.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)Content.Items.FLUIDIZER_CASING.get()).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200472_a("GCG").func_200473_b("bigreactors:general").func_200465_a("has_item", (ICriterionInstance)FluidizerRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)Content.Items.FLUIDIZER_CASING.get()))).func_200467_a(c, FluidizerRecipeGenerator.fluidizerRecipeName("glass"));
    }

    private void controller(Consumer<IFinishedRecipe> c) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Content.Items.FLUIDIZER_CONTROLLER.get())).func_200462_a(Character.valueOf('C'), (IItemProvider)Content.Items.FLUIDIZER_CASING.get()).func_200469_a(Character.valueOf('Y'), ContentTags.Items.INGOTS_YELLORIUM).func_200469_a(Character.valueOf('P'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('E'), (ITag)Tags.Items.GEMS_EMERALD).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222029_iU).func_200472_a("CXC").func_200472_a("YEY").func_200472_a("CPC").func_200473_b("bigreactors:general").func_200465_a("has_item", (ICriterionInstance)FluidizerRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)Content.Items.FLUIDIZER_CASING.get()))).func_200465_a("has_item2", (ICriterionInstance)FluidizerRecipeGenerator.func_200409_a((ITag)Tags.Items.DUSTS_GLOWSTONE)).func_200467_a(c, FluidizerRecipeGenerator.fluidizerRecipeName("controller"));
    }

    private void port(Consumer<IFinishedRecipe> c, String name, Supplier<? extends IItemProvider> result, IItemProvider item1, ITag<Item> tag2, ITag<Item> tag3) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result.get()).func_200462_a(Character.valueOf('C'), (IItemProvider)Content.Items.FLUIDIZER_CASING.get()).func_200462_a(Character.valueOf('1'), item1).func_200469_a(Character.valueOf('2'), tag2).func_200469_a(Character.valueOf('3'), tag3).func_200472_a("C2C").func_200472_a("313").func_200472_a("C2C").func_200473_b("bigreactors:general").func_200465_a("has_item", (ICriterionInstance)FluidizerRecipeGenerator.func_200403_a((IItemProvider)((IItemProvider)Content.Items.FLUIDIZER_CASING.get()))).func_200465_a("has_item2", (ICriterionInstance)FluidizerRecipeGenerator.func_200403_a((IItemProvider)item1)).func_200467_a(c, FluidizerRecipeGenerator.fluidizerRecipeName(name));
    }

    private static ResourceLocation fluidizerRecipeName(String name) {
        return ExtremeReactors.newID("fluidizer/" + name);
    }
}

