/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rubidium")
public class SodiumClientMod {
    private static SodiumGameOptions CONFIG;
    private static Logger LOGGER;
    private static String MOD_VERSION;
    public static final String MODID = "rubidium";
    public static boolean flywheelLoaded;
    public static boolean oculusLoaded;

    public SodiumClientMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onInitializeClient);
    }

    public void onInitializeClient(FMLCommonSetupEvent event) {
        flywheelLoaded = ModList.get().isLoaded("flywheel");
        oculusLoaded = ModList.get().isLoaded("oculus");
        MOD_VERSION = ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().toString();
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            CONFIG = SodiumClientMod.loadConfig();
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            LOGGER = LogManager.getLogger((String)"Rubidium");
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        SodiumGameOptions config = SodiumGameOptions.load(FMLPaths.CONFIGDIR.get().resolve("rubidium-options.json"));
        SodiumClientMod.onConfigChanged(config);
        return config;
    }

    public static void onConfigChanged(SodiumGameOptions options) {
        UnsafeUtil.setEnabled(options.advanced.allowDirectMemoryAccess);
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Rubidium");
    }
}

