/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.coderbot.iris.compat.sodium.impl.block_id.ChunkBuildBuffersExt;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private final ChunkRenderContainer<T> render;
    private final BlockPos offset;
    private final ChunkRenderContext context;

    public ChunkRenderRebuildTask(ChunkRenderContainer<T> render, ChunkRenderContext context, BlockPos offset) {
        this.render = render;
        this.offset = offset;
        this.context = context;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        VisGraph occluder = new VisGraph();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init(renderData);
        cache.init(this.context);
        WorldSlice slice = cache.getWorldSlice();
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        Map modelDataMap = ModelDataManager.getModelData((World)Minecraft.func_71410_x().field_71441_e, (ChunkPos)new ChunkPos(SectionPos.func_218159_a((int)baseX), SectionPos.func_218159_a((int)baseZ)));
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos renderOffset = this.offset;
        for (int relY = 0; relY < 16; ++relY) {
            if (cancellationSource.isCancelled()) {
                return null;
            }
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int relX = 0; relX < 16; ++relX) {
                    TileEntityRenderer renderer;
                    TileEntity entity;
                    FluidState fluidState;
                    BlockState blockState = slice.getBlockStateRelative(relX + 16, relY + 16, relZ + 16);
                    if (blockState.func_196958_f()) continue;
                    pos.func_181079_c(baseX + relX, baseY + relY, baseZ + relZ);
                    buffers.setRenderOffset(pos.func_177958_n() - renderOffset.func_177958_n(), pos.func_177956_o() - renderOffset.func_177956_o(), pos.func_177952_p() - renderOffset.func_177952_p());
                    if (blockState.func_185901_i() == BlockRenderType.MODEL) {
                        for (RenderType layer : RenderType.func_228661_n_()) {
                            if (!RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                            ForgeHooksClient.setRenderLayer((RenderType)layer);
                            IModelData modelData = (IModelData)modelDataMap.getOrDefault(pos, EmptyModelData.INSTANCE);
                            if (SodiumClientMod.oculusLoaded && buffers instanceof ChunkBuildBuffersExt) {
                                ((ChunkBuildBuffersExt)buffers).iris$setMaterialId(blockState, (short)-1);
                            }
                            IBakedModel model = cache.getBlockModels().func_178125_b(blockState);
                            long seed = blockState.func_209533_a((BlockPos)pos);
                            if (!cache.getBlockRenderer().renderModel(slice, blockState, (BlockPos)pos, model, buffers.get(layer), true, seed, modelData)) continue;
                            bounds.addBlock(relX, relY, relZ);
                        }
                    }
                    if (!(fluidState = blockState.func_204520_s()).func_206888_e()) {
                        RenderType layer;
                        layer = RenderType.func_228661_n_().iterator();
                        while (layer.hasNext()) {
                            RenderType layer2 = (RenderType)layer.next();
                            if (!RenderTypeLookup.canRenderInLayer((FluidState)fluidState, (RenderType)layer2)) continue;
                            if (SodiumClientMod.oculusLoaded && buffers instanceof ChunkBuildBuffersExt) {
                                ((ChunkBuildBuffersExt)buffers).iris$setMaterialId(fluidState.func_206883_i(), (short)1);
                            }
                            ForgeHooksClient.setRenderLayer((RenderType)layer2);
                            if (!cache.getFluidRenderer().render(slice, fluidState, (BlockPos)pos, buffers.get(layer2))) continue;
                            bounds.addBlock(relX, relY, relZ);
                        }
                    }
                    if (blockState.hasTileEntity() && (entity = slice.func_175625_s((BlockPos)pos)) != null && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity)) != null) {
                        renderData.addBlockEntity(entity, !renderer.func_188185_a(entity));
                        bounds.addBlock(relX, relY, relZ);
                    }
                    if (!blockState.func_200015_d((IBlockReader)slice, (BlockPos)pos)) continue;
                    occluder.func_178606_a((BlockPos)pos);
                }
            }
        }
        ForgeHooksClient.setRenderLayer(null);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
        }
        renderData.setOcclusionData(occluder.func_178607_a());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    @Override
    public void releaseResources() {
        this.context.releaseResources();
    }
}

