/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.level.ColorResolver;

public class BiomeColorCache {
    private static final int MODEL_RADIUS = 2;
    private static final int BLENDED_COLORS_DIM = 20;
    private final ColorResolver resolver;
    private final WorldSlice slice;
    private final int[] cache;
    private final int[] blendedColorsZ;
    private final int[] blendedColorsXZ;
    private final int[] blendedColorsXYZ;
    private final int radius;
    private final int diameter;
    private final int dim;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int blendedColorsMinX;
    private final int blendedColorsMinY;
    private final int blendedColorsMinZ;

    public BiomeColorCache(ColorResolver resolver, WorldSlice slice) {
        this.resolver = resolver;
        this.slice = slice;
        this.radius = Minecraft.func_71410_x().field_71474_y.field_205217_U;
        SectionPos origin = this.slice.getOrigin();
        this.minX = origin.func_218161_d() - (this.radius + 2);
        this.minY = origin.func_218151_e() - (this.radius + 2);
        this.minZ = origin.func_218164_f() - (this.radius + 2);
        this.dim = 16 + (this.radius + 2) * 2;
        this.blendedColorsMinX = origin.func_218161_d() - 2;
        this.blendedColorsMinY = origin.func_218151_e() - 2;
        this.blendedColorsMinZ = origin.func_218164_f() - 2;
        this.cache = new int[this.dim * this.dim * this.dim];
        this.blendedColorsZ = new int[this.dim * this.dim * 20];
        this.blendedColorsXZ = new int[this.dim * 20 * 20];
        this.blendedColorsXYZ = new int[8000];
        this.diameter = this.radius * 2 + 1;
        Arrays.fill(this.cache, -1);
        Arrays.fill(this.blendedColorsZ, -1);
        Arrays.fill(this.blendedColorsXZ, -1);
        Arrays.fill(this.blendedColorsXYZ, -1);
    }

    public int getBlendedColor(BlockPos pos) {
        int z2;
        int x2 = pos.func_177958_n() - this.blendedColorsMinX;
        int y2 = pos.func_177956_o() - this.blendedColorsMinY;
        int index = (y2 * 20 + x2) * 20 + (z2 = pos.func_177952_p() - this.blendedColorsMinZ);
        index = index >= this.blendedColorsXYZ.length ? this.blendedColorsXYZ.length - 1 : index;
        int color = this.blendedColorsXYZ[index];
        if (color == -1) {
            this.blendedColorsXYZ[index] = color = this.calculateBlendedColor(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return color;
    }

    private int calculateBlendedColor(int posX, int posY, int posZ) {
        if (this.radius == 0) {
            return this.getColor(posX, posY, posZ);
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int minY = posY - this.radius;
        int maxY = posY + this.radius;
        for (int y2 = minY; y2 <= maxY; ++y2) {
            int color = this.getBlendedColorXZ(posX, y2, posZ);
            r += ColorARGB.unpackRed(color);
            g += ColorARGB.unpackGreen(color);
            b += ColorARGB.unpackBlue(color);
        }
        return ColorARGB.pack(r / this.diameter, g / this.diameter, b / this.diameter, 255);
    }

    private int getBlendedColorXZ(int x, int y, int z) {
        int y2 = y - this.minY;
        int x2 = x - this.blendedColorsMinX;
        int z2 = z - this.blendedColorsMinZ;
        int index = (y2 * 20 + x2) * 20 + z2;
        index = index >= this.blendedColorsXZ.length ? this.blendedColorsXZ.length - 1 : index;
        int color = this.blendedColorsXZ[index];
        if (color == -1) {
            this.blendedColorsXZ[index] = color = this.calculateBlendedColorXZ(x, y, z);
        }
        return color;
    }

    private int calculateBlendedColorXZ(int posX, int posY, int posZ) {
        int r = 0;
        int g = 0;
        int b = 0;
        int minX = posX - this.radius;
        int maxX = posX + this.radius;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            int color = this.getBlendedColorZ(x2, posY, posZ);
            r += ColorARGB.unpackRed(color);
            g += ColorARGB.unpackGreen(color);
            b += ColorARGB.unpackBlue(color);
        }
        return ColorARGB.pack(r / this.diameter, g / this.diameter, b / this.diameter, 255);
    }

    private int getBlendedColorZ(int x, int y, int z) {
        int y2 = y - this.minY;
        int x2 = x - this.minX;
        int z2 = z - this.blendedColorsMinZ;
        int index = (y2 * this.dim + x2) * 20 + z2;
        index = index >= this.blendedColorsZ.length ? this.blendedColorsZ.length - 1 : index;
        int color = this.blendedColorsZ[index];
        if (color == -1) {
            this.blendedColorsZ[index] = color = this.calculateBlendedColorZ(x, y, z);
        }
        return color;
    }

    private int calculateBlendedColorZ(int posX, int posY, int posZ) {
        int r = 0;
        int g = 0;
        int b = 0;
        int minZ = posZ - this.radius;
        int maxZ = posZ + this.radius;
        for (int z2 = minZ; z2 <= maxZ; ++z2) {
            int color = this.getColor(posX, posY, z2);
            r += ColorARGB.unpackRed(color);
            g += ColorARGB.unpackGreen(color);
            b += ColorARGB.unpackBlue(color);
        }
        return ColorARGB.pack(r / this.diameter, g / this.diameter, b / this.diameter, 255);
    }

    private int getColor(int x, int y, int z) {
        int y2 = y - this.minY;
        int x2 = x - this.minX;
        int z2 = z - this.minZ;
        int index = (y2 * this.dim + x2) * this.dim + z2;
        index = index >= this.cache.length ? this.cache.length - 1 : index;
        int color = this.cache[index];
        if (color == -1) {
            this.cache[index] = color = this.calculateColor(x, y, z);
        }
        return color;
    }

    private int calculateColor(int x, int y, int z) {
        return this.resolver.getColor(this.slice.getBiome(x, y, z), (double)x, (double)z);
    }
}

