/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class BackpackRenderInfo {
    private static final String RENDER_INFO_TAG = "renderInfo";
    private static final String TANKS_TAG = "tanks";
    private static final String UPGRADES_TAG = "upgrades";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final Map<String, UpgradeRenderDataType<?>> RENDER_DATA_TYPES;
    private final ItemStack backpack;
    private final Supplier<Runnable> getBackpackSaveHandler;
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private final Map<UpgradeRenderDataType<?>, IUpgradeRenderData> upgradeData = new HashMap();

    public BackpackRenderInfo(ItemStack backpack, Supplier<Runnable> getBackpackSaveHandler) {
        this.backpack = backpack;
        this.getBackpackSaveHandler = getBackpackSaveHandler;
        this.deserialize();
    }

    public <T extends IUpgradeRenderData> Optional<T> getUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType) {
        if (!this.upgradeData.containsKey(upgradeRenderDataType)) {
            return Optional.empty();
        }
        return upgradeRenderDataType.cast(this.upgradeData.get(upgradeRenderDataType));
    }

    public <T extends IUpgradeRenderData> void setUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType, T renderData) {
        this.upgradeData.put(upgradeRenderDataType, renderData);
        this.serializeUpgradeData(upgrades -> upgrades.func_218657_a(upgradeRenderDataType.getName(), (INBT)renderData.serializeNBT()));
        this.save();
    }

    private void serializeUpgradeData(Consumer<CompoundNBT> modifyUpgradesTag) {
        CompoundNBT renderInfo = this.getRenderInfoTag();
        CompoundNBT upgrades = renderInfo.func_74775_l(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.func_218657_a(UPGRADES_TAG, (INBT)upgrades);
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
    }

    private void deserialize() {
        this.deserializeTanks();
        this.deserializeBattery();
        this.deserializeUpgrades();
    }

    private void deserializeUpgrades() {
        CompoundNBT renderInfo = this.getRenderInfoTag();
        CompoundNBT upgrades = renderInfo.func_74775_l(UPGRADES_TAG);
        upgrades.func_150296_c().forEach(key -> {
            if (RENDER_DATA_TYPES.containsKey(key)) {
                UpgradeRenderDataType<?> upgradeRenderDataType = RENDER_DATA_TYPES.get(key);
                this.upgradeData.put(upgradeRenderDataType, (IUpgradeRenderData)upgradeRenderDataType.deserialize(upgrades.func_74775_l(key)));
            }
        });
    }

    private void save() {
        this.getBackpackSaveHandler.get().run();
    }

    public void deserializeFrom(CompoundNBT renderInfoNbt) {
        this.reset();
        this.backpack.func_77983_a(RENDER_INFO_TAG, (INBT)renderInfoNbt);
        this.deserialize();
    }

    public CompoundNBT getNbt() {
        return this.getRenderInfoTag();
    }

    public void reset() {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        NBTHelper.removeTag(this.backpack, RENDER_INFO_TAG);
        this.save();
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks() {
        CompoundNBT renderInfo = this.getRenderInfoTag();
        ListNBT tanks = renderInfo.func_150295_c(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundNBT tank = tanks.func_150305_b(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.func_74779_i(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.func_74775_l(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery() {
        this.batteryRenderInfo = NBTHelper.getCompound(this.getRenderInfoTag(), BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundNBT tankInfo = tankRenderInfo.serialize();
        CompoundNBT renderInfo = this.getRenderInfoTag();
        ListNBT tanks = renderInfo.func_150295_c(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundNBT tank = tanks.func_150305_b(i);
            if (!tank.func_74779_i(TANK_POSITION_TAG).equals(tankPosition.func_176610_l())) continue;
            tank.func_218657_a(TANK_INFO_TAG, (INBT)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundNBT tankPositionInfo = new CompoundNBT();
            tankPositionInfo.func_74778_a(TANK_POSITION_TAG, tankPosition.func_176610_l());
            tankPositionInfo.func_218657_a(TANK_INFO_TAG, (INBT)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.func_218657_a(TANKS_TAG, (INBT)tanks);
        }
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundNBT batteryInfo = batteryRenderInfo.serialize();
        CompoundNBT renderInfo = this.getRenderInfoTag();
        renderInfo.func_218657_a(BATTERY_TAG, (INBT)batteryInfo);
        NBTHelper.setCompoundNBT(this.backpack, RENDER_INFO_TAG, renderInfo);
        this.save();
    }

    @Nonnull
    private CompoundNBT getRenderInfoTag() {
        return NBTHelper.getCompound(this.backpack, RENDER_INFO_TAG).orElse(new CompoundNBT());
    }

    public Map<UpgradeRenderDataType<?>, IUpgradeRenderData> getUpgradeRenderData() {
        return this.upgradeData;
    }

    public void removeUpgradeRenderData(UpgradeRenderDataType<?> type) {
        this.upgradeData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.func_82580_o(type.getName()));
        this.save();
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)SmeltingUpgradeRenderData.TYPE.getName(), SmeltingUpgradeRenderData.TYPE);
        builder.put((Object)JukeboxUpgradeRenderData.TYPE.getName(), JukeboxUpgradeRenderData.TYPE);
        RENDER_DATA_TYPES = builder.build();
    }
}

