/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pickup;

import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pickup.PickupUpgradeItem;

public class PickupUpgradeWrapper
extends UpgradeWrapperBase<PickupUpgradeWrapper, PickupUpgradeItem>
implements IPickupResponseUpgrade,
IContentsFilteredUpgrade {
    private static final int FULL_COOLDOWN = 60;
    private final ContentsFilterLogic filterLogic;

    public PickupUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, stack -> this.save(), ((PickupUpgradeItem)this.upgradeItem).getFilterSlotCount(), backpackWrapper::getInventoryHandler);
    }

    @Override
    public ItemStack pickup(World world, ItemStack stack, boolean simulate) {
        ItemStack ret;
        if (this.isInCooldown(world)) {
            return stack;
        }
        if (!this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        int originalCount = stack.func_190916_E();
        if (originalCount == (ret = this.backpackWrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate)).func_190916_E()) {
            this.setCooldown(world, 60);
        }
        return ret;
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }
}

