/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pump.PumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class PumpUpgradeWrapper
extends UpgradeWrapperBase<PumpUpgradeWrapper, PumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DID_NOTHING_COOLDOWN_TIME = 40;
    private static final int HAND_INTERACTION_COOLDOWN_TIME = 3;
    private static final int WORLD_INTERACTION_COOLDOWN_TIME = 20;
    private static final int FLUID_HANDLER_INTERACTION_COOLDOWN_TIME = 20;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private static final int PUMP_IN_WORLD_RANGE = 4;
    private static final int PUMP_IN_WORLD_RANGE_SQR = 16;
    private long cooldownTime = 0L;
    private long lastHandActionTime = -1L;
    private final FluidFilterLogic fluidFilterLogic;

    protected PumpUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.fluidFilterLogic = new FluidFilterLogic((Integer)Config.COMMON.pumpUpgrade.filterSlots.get(), upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.cooldownTime > 0L && this.cooldownTime > world.func_82737_E()) {
            return;
        }
        this.cooldownTime = world.func_82737_E() + (long)this.backpackWrapper.getFluidHandler().map(backpackFluidHandler -> this.tick((IFluidHandlerItem)backpackFluidHandler, entity, world, pos)).orElse(40).intValue();
    }

    private int tick(IFluidHandlerItem backpackFluidHandler, @Nullable LivingEntity entity, World world, BlockPos pos) {
        if (entity == null) {
            Optional<Integer> newCooldown = this.handleInWorldInteractions(backpackFluidHandler, world, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        } else if (this.shouldInteractWithHand() && entity instanceof PlayerEntity && this.handleFluidContainerInHands((PlayerEntity)entity, (IFluidHandler)backpackFluidHandler)) {
            this.lastHandActionTime = world.func_82737_E();
            return 3;
        }
        return this.lastHandActionTime + 30L > world.func_82737_E() ? 3 : 40;
    }

    private Optional<Integer> handleInWorldInteractions(IFluidHandlerItem backpackFluidHandler, World world, BlockPos pos) {
        Optional<Integer> newCooldown;
        if (this.shouldInteractWithHand() && this.handleFluidContainersInHandsOfNearbyPlayers(world, pos, (IFluidHandler)backpackFluidHandler)) {
            this.lastHandActionTime = world.func_82737_E();
            return Optional.of(3);
        }
        if (this.shouldInteractWithWorld() && (newCooldown = this.interactWithWorld(world, pos, (IFluidHandler)backpackFluidHandler)).isPresent()) {
            return newCooldown;
        }
        return this.interactWithAttachedFluidHandlers(world, pos, (IFluidHandler)backpackFluidHandler);
    }

    private Optional<Integer> interactWithAttachedFluidHandlers(World world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        for (Direction dir : Direction.values()) {
            boolean successful = WorldHelper.getTile((IBlockReader)world, pos.func_177971_a(dir.func_176730_m())).map(te -> te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()).map(fluidHandler -> {
                if (this.isInput()) {
                    return this.fillFromFluidHandler((IFluidHandler)fluidHandler, backpackFluidHandler, this.getMaxInOut());
                }
                return this.fillFluidHandler((IFluidHandler)fluidHandler, backpackFluidHandler, this.getMaxInOut());
            }).orElse(false)).orElse(false);
            if (!successful) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private int getMaxInOut() {
        return Math.max(1000, (Integer)Config.COMMON.pumpUpgrade.maxInputOutput.get() * this.backpackWrapper.getNumberOfSlotRows() * PumpUpgradeWrapper.getAdjustedStackMultiplier(this.backpackWrapper));
    }

    public static int getAdjustedStackMultiplier(IBackpackWrapper backpackWrapper) {
        return 1 + (int)((Double)Config.COMMON.pumpUpgrade.stackMultiplierRatio.get() * (double)(backpackWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    private Optional<Integer> interactWithWorld(World world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        if (this.isInput()) {
            return this.fillFromBlockInRange(world, pos, backpackFluidHandler);
        }
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.func_177971_a(dir.func_176730_m());
            if (!this.placeFluidInWorld(world, backpackFluidHandler, dir, offsetPos)) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private boolean placeFluidInWorld(World world, IFluidHandler backpackFluidHandler, Direction dir, BlockPos offsetPos) {
        if (dir != Direction.UP) {
            for (int tank = 0; tank < backpackFluidHandler.getTanks(); ++tank) {
                FluidStack tankFluid = backpackFluidHandler.getFluidInTank(tank);
                if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid.getFluid()) || !this.isValidForFluidPlacement(world, offsetPos) || !FluidUtil.tryPlaceFluid(null, (World)world, (Hand)Hand.MAIN_HAND, (BlockPos)offsetPos, (IFluidHandler)backpackFluidHandler, (FluidStack)tankFluid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidForFluidPlacement(World world, BlockPos offsetPos) {
        BlockState blockState = world.func_180495_p(offsetPos);
        Block block = blockState.func_177230_c();
        return block.isAir(blockState, (IBlockReader)world, offsetPos) || !blockState.func_204520_s().func_206888_e() && !blockState.func_204520_s().func_206889_d();
    }

    private Optional<Integer> fillFromBlockInRange(World world, BlockPos basePos, IFluidHandler backpackFluidHandler) {
        LinkedList<BlockPos> nextPositions = new LinkedList<BlockPos>();
        HashSet<BlockPos> searchedPositions = new HashSet<BlockPos>();
        nextPositions.add(basePos);
        while (!nextPositions.isEmpty()) {
            BlockPos pos = (BlockPos)nextPositions.poll();
            if (this.fillFromBlock(world, pos, backpackFluidHandler)) {
                return Optional.of((int)(Math.max(1.0, Math.sqrt(basePos.func_177951_i((Vector3i)pos))) * 20.0));
            }
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.func_177971_a(dir.func_176730_m());
                if (searchedPositions.contains(offsetPos)) continue;
                searchedPositions.add(offsetPos);
                if (!(basePos.func_177951_i((Vector3i)offsetPos) < 16.0)) continue;
                nextPositions.add(offsetPos);
            }
        }
        return Optional.empty();
    }

    private boolean fillFromBlock(World world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        FluidState fluidState = world.func_204610_c(pos);
        if (!fluidState.func_206888_e()) {
            FluidBlockWrapper targetFluidHandler;
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IFluidBlock) {
                targetFluidHandler = new FluidBlockWrapper((IFluidBlock)block, world, pos);
            } else if (block instanceof IBucketPickupHandler) {
                targetFluidHandler = new BucketPickupHandlerWrapper((IBucketPickupHandler)block, world, pos);
            } else {
                return false;
            }
            return this.fillFromFluidHandler((IFluidHandler)targetFluidHandler, backpackFluidHandler);
        }
        return false;
    }

    private boolean handleFluidContainersInHandsOfNearbyPlayers(World world, BlockPos pos, IFluidHandler backpackFluidHandler) {
        AxisAlignedBB searchBox = new AxisAlignedBB(pos).func_186662_g(3.0);
        for (PlayerEntity player : world.func_217369_A()) {
            if (!searchBox.func_197744_e(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()) || !this.handleFluidContainerInHands(player, backpackFluidHandler)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFluidContainerInHands(PlayerEntity player, IFluidHandler backpackFluidHandler) {
        return this.handleFluidContainerInHand(backpackFluidHandler, player, Hand.MAIN_HAND) || this.handleFluidContainerInHand(backpackFluidHandler, player, Hand.OFF_HAND);
    }

    private boolean handleFluidContainerInHand(IFluidHandler backpackFluidHandler, PlayerEntity player, Hand hand) {
        ItemStack itemInHand = player.func_184586_b(hand);
        if (itemInHand == this.backpackWrapper.getBackpack()) {
            return false;
        }
        return itemInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(itemFluidHandler -> {
            if (this.isInput()) {
                return this.fillFromHand(player, hand, (IFluidHandlerItem)itemFluidHandler, backpackFluidHandler);
            }
            return this.fillContainerInHand(player, hand, (IFluidHandlerItem)itemFluidHandler, backpackFluidHandler);
        }).orElse(false);
    }

    private boolean fillContainerInHand(PlayerEntity player, Hand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler backpackFluidHandler) {
        boolean ret = this.fillFluidHandler((IFluidHandler)itemFluidHandler, backpackFluidHandler);
        if (ret) {
            player.func_184611_a(hand, itemFluidHandler.getContainer());
        }
        return ret;
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler) {
        return this.fillFluidHandler(fluidHandler, backpackFluidHandler, 1000);
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler, int maxFill) {
        boolean ret = false;
        for (int tank = 0; tank < backpackFluidHandler.getTanks(); ++tank) {
            FluidStack tankFluid = backpackFluidHandler.getFluidInTank(tank);
            if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid.getFluid()) || FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)backpackFluidHandler, (FluidStack)new FluidStack(tankFluid.getFluid(), maxFill), (boolean)true).isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean fillFromHand(PlayerEntity player, Hand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler backpackFluidHandler) {
        if (this.fillFromFluidHandler((IFluidHandler)itemFluidHandler, backpackFluidHandler)) {
            player.func_184611_a(hand, itemFluidHandler.getContainer());
            return true;
        }
        return false;
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler) {
        return this.fillFromFluidHandler(fluidHandler, backpackFluidHandler, 1000);
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler backpackFluidHandler, int maxDrain) {
        FluidStack containedFluid = fluidHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        if (!containedFluid.isEmpty() && this.fluidFilterLogic.fluidMatches(containedFluid.getFluid())) {
            return !FluidUtil.tryFluidTransfer((IFluidHandler)backpackFluidHandler, (IFluidHandler)fluidHandler, (FluidStack)containedFluid, (boolean)true).isEmpty();
        }
        return false;
    }

    public void setIsInput(boolean input) {
        NBTHelper.setBoolean(this.upgrade, "input", input);
        this.save();
    }

    public boolean isInput() {
        return NBTHelper.getBoolean(this.upgrade, "input").orElse(true);
    }

    public FluidFilterLogic getFluidFilterLogic() {
        return this.fluidFilterLogic;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        NBTHelper.setBoolean(this.upgrade, "interactWithHand", interactWithHand);
        this.save();
    }

    public boolean shouldInteractWithHand() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithHand").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithHandDefault());
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        NBTHelper.setBoolean(this.upgrade, "interactWithWorld", interactWithWorld);
        this.save();
    }

    public boolean shouldInteractWithWorld() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithWorld").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithWorldDefault());
    }
}

