/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.tileentity;

import javax.annotation.Nullable;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.ShelfBlock;
import knightminer.inspirations.building.inventory.ShelfContainer;
import knightminer.inspirations.building.tileentity.ShelfInventory;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.InventorySlotSyncPacket;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.tileentity.IRetexturedTileEntity;
import slimeknights.mantle.tileentity.NamableTileEntity;
import slimeknights.mantle.util.RetexturedHelper;

public class ShelfTileEntity
extends NamableTileEntity
implements IRetexturedTileEntity {
    public static final ModelProperty<Integer> BOOKS = new ModelProperty();
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.inspirations.shelf.name");
    private float enchantBonus = Float.NaN;
    private final ShelfInventory inventory = new ShelfInventory(this);
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.inventory);
    private final IModelData data = new ModelDataMap.Builder().withProperty(BOOKS).withProperty(RetexturedHelper.BLOCK_PROPERTY).build();
    private static final String TAG_ITEMS = "Items";

    public ShelfTileEntity() {
        super(InspirationsBuilding.shelfTileEntity, TITLE);
    }

    private int getIndexFromHit(ItemStack held, Vector3d click) {
        Direction dir;
        double clicked;
        int pixel;
        int shelfIndex;
        int slotIndex = (click.field_72448_b <= 0.4375 ? 8 : 0) + (shelfIndex = (pixel = MathHelper.func_76125_a((int)((int)((clicked = (double)(dir = ((Direction)this.func_195044_w().func_177229_b((Property)ShelfBlock.FACING)).func_176735_f()).func_82601_c() * (click.field_72450_a - 0.5) + (double)dir.func_82599_e() * (click.field_72449_c - 0.5) + 0.5) * 16.0)), (int)0, (int)15)) / 2);
        if (!this.inventory.getStackInSlot(slotIndex).func_190926_b()) {
            return slotIndex;
        }
        boolean previousEmpty = false;
        if (shelfIndex != 0) {
            ItemStack previous = this.inventory.getStackInSlot(slotIndex - 1);
            if (!previous.func_190926_b() && !InspirationsRegistry.isBook(previous)) {
                return slotIndex - 1;
            }
            previousEmpty = previous.func_190926_b();
        }
        if (held.func_190926_b()) {
            return -1;
        }
        if (InspirationsRegistry.isBook(held)) {
            return slotIndex;
        }
        if (shelfIndex == 7 || !this.inventory.getStackInSlot(slotIndex + 1).func_190926_b()) {
            return previousEmpty ? slotIndex - 1 : -1;
        }
        if (previousEmpty && pixel % 2 == 0) {
            if (shelfIndex == 1) {
                return slotIndex - 1;
            }
            ItemStack beforePrevious = this.inventory.getStackInSlot(slotIndex - 2);
            if (beforePrevious.func_190926_b() || InspirationsRegistry.isBook(beforePrevious)) {
                return slotIndex - 1;
            }
        }
        return slotIndex;
    }

    public boolean interact(PlayerEntity player, Hand hand, Vector3d click) {
        ItemStack stack = player.func_184586_b(hand);
        int index = this.getIndexFromHit(stack, click);
        if (index == -1) {
            return false;
        }
        ItemStack current = this.inventory.getStackInSlot(index);
        if (!current.func_190926_b()) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)current, (int)player.field_71071_by.field_70461_c);
                this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
            }
            return true;
        }
        if (this.inventory.canInsertItem(index, stack)) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.inventory.setStackInSlot(index, stack.func_77979_a(1));
            }
            return true;
        }
        return false;
    }

    public void onSlotChanged(int slot, ItemStack oldStack, ItemStack newStack) {
        World world = this.func_145831_w();
        if (world != null && !world.field_72995_K) {
            InspirationsNetwork.sendToClients(world, this.field_174879_c, (ISimplePacket)new InventorySlotSyncPacket(newStack, slot, this.field_174879_c));
        }
        if (world != null) {
            if (world.field_72995_K) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
            if (oldStack.func_77973_b() == InspirationsBuilding.redstoneBook ^ newStack.func_77973_b() == InspirationsBuilding.redstoneBook) {
                world.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
        this.enchantBonus = Float.NaN;
    }

    public ShelfInventory getInventory() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @Nullable
    public Container createMenu(int winId, PlayerInventory playerInv, PlayerEntity player) {
        return new ShelfContainer(winId, playerInv, this);
    }

    public int getComparatorPower() {
        for (int i = 16; i >= 0; --i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() != InspirationsBuilding.redstoneBook) continue;
            return i;
        }
        return 0;
    }

    public float getEnchantPower() {
        if (!Float.isNaN(this.enchantBonus)) {
            return this.enchantBonus;
        }
        float books = 0.0f;
        for (int i = 0; i < 16; ++i) {
            float power;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !((power = InspirationsRegistry.getBookEnchantingPower(stack)) > 0.0f)) continue;
            books += power;
        }
        this.enchantBonus = books / 16.0f;
        return this.enchantBonus;
    }

    public IModelData getModelData() {
        int books = 0;
        for (int i = 0; i < 16; ++i) {
            if (!InspirationsRegistry.isBook(this.inventory.getStackInSlot(i))) continue;
            books |= 1 << i;
        }
        this.data.setData(BOOKS, (Object)books);
        Block texture = this.getTexture();
        if (texture != Blocks.field_150350_a) {
            this.data.setData(RetexturedHelper.BLOCK_PROPERTY, (Object)texture);
        }
        return this.data;
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void writeSynced(CompoundNBT tags) {
        super.writeSynced(tags);
        tags.func_218657_a(TAG_ITEMS, (INBT)this.inventory.serializeNBT());
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tags) {
        super.func_230337_a_(blockState, tags);
        if (tags.func_150297_b(TAG_ITEMS, 9)) {
            this.inventory.deserializeNBT(tags.func_150295_c(TAG_ITEMS, 10));
            if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
                this.requestModelDataUpdate();
                this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
            }
        }
    }
}

