/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import slimeknights.mantle.config.CachedBoolean;
import slimeknights.mantle.config.CachedValue;

public class Config {
    private static final List<CachedValue<?>> SERVER_VALUES = new ArrayList();
    private static final List<CachedValue<?>> CLIENT_VALUES = new ArrayList();
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec OVERRIDE_SPEC;
    public static final CachedBoolean buildingModule;
    public static final CachedBoolean utilityModule;
    public static final CachedBoolean toolsModule;
    public static final CachedBoolean tweaksModule;
    public static final CachedBoolean recipesModule;
    public static final CachedBoolean showAllVariants;
    public static final CachedBoolean enableRope;
    public static final CachedBoolean enableRopeLadder;
    public static final CachedBoolean enableGlassDoor;
    public static final CachedBoolean enableMulch;
    public static final CachedBoolean enablePath;
    public static final CachedBoolean enableFlowers;
    public static final CachedBoolean enableEnlightenedBush;
    public static final CachedBoolean climbableIronBars;
    public static final CachedBoolean enableBookshelf;
    public static final CachedBoolean enableColoredBooks;
    public static final CachedBoolean bookshelvesBoostEnchanting;
    public static final CachedValue<Double> defaultEnchantingPower;
    @Deprecated
    public static final CachedValue<String> bookKeywords;
    private static final String BOOK_KEYWORD_DEFAULTS = "almanac, atlas, book, catalogue, concordance, dictionary, directory, encyclopedia, guide, journal, lexicon, manual, thesaurus, tome";
    public static final CachedBoolean enableTorchLever;
    public static final CachedBoolean enableRedstoneBook;
    public static final CachedBoolean enableCarpetedTrapdoor;
    public static final CachedBoolean enableCarpetedPressurePlate;
    public static final CachedBoolean enableCollector;
    public static final CachedBoolean enablePipe;
    public static final CachedBoolean pipeUpwards;
    public static final CachedBoolean cauldronRecipes;
    public static final CachedBoolean cauldronConcrete;
    public static final CachedBoolean extendedCauldron;
    public static final CachedBoolean extendedCaulronRecipes;
    public static final CachedBoolean cauldronIce;
    public static final CachedBoolean enableCauldronFluids;
    public static final CachedBoolean enableCauldronDyeing;
    public static final CachedBoolean extraBottleRecipes;
    public static final CachedBoolean enableCauldronPotions;
    public static final CachedBoolean enableCauldronBrewing;
    public static final CachedBoolean cauldronTipArrows;
    public static final CachedBoolean fasterCauldronRain;
    public static final CachedBoolean enableLock;
    public static final CachedBoolean enableRedstoneCharger;
    public static final CachedBoolean enableChargedArrow;
    public static final CachedBoolean harvestHangingVines;
    public static final CachedBoolean shearsReclaimMelons;
    public static final CachedBoolean enableNorthCompass;
    public static final CachedBoolean enableBarometer;
    public static final CachedBoolean enablePhotometer;
    public static final CachedBoolean enableDimensionCompass;
    public static final CachedBoolean moreShieldEnchantments;
    public static final CachedBoolean shieldEnchantmentTable;
    public static final CachedBoolean fixShieldTooltip;
    public static final CachedBoolean axeWeaponEnchants;
    public static final CachedBoolean axeEnchantmentTable;
    public static final CachedBoolean enablePigDesaddle;
    public static final CachedBoolean enableFittedCarpets;
    public static final CachedBoolean lilypadBreakFall;
    public static final CachedBoolean unstackableRecipeAlts;
    public static final CachedBoolean dispensersPlaceAnvils;
    public static final CachedBoolean milkCooldown;
    public static final CachedValue<Integer> milkCooldownTime;
    public static final CachedBoolean waterlogHopper;
    public static final CachedBoolean betterCauldronItem;
    public static final CachedBoolean coloredEnchantedRibbons;
    public static final CachedBoolean coloredFireworkItems;
    public static final CachedBoolean customPortalColor;
    public static final CachedBoolean enableHeartbeet;
    public static final CachedBoolean brewHeartbeet;
    public static final CachedBoolean enableBlockCrops;
    public static final CachedBoolean smoothBlockCropGrowth;
    public static final CachedBoolean bonemealBlockCrop;
    public static final CachedBoolean nerfCactusFarms;
    public static final CachedBoolean bonemealMushrooms;
    public static final CachedBoolean bonemealDeadBush;
    public static final CachedBoolean bonemealGrassSpread;
    public static final CachedBoolean bonemealMyceliumSpread;
    public static final CachedBoolean caveSpiderDrops;
    public static final CachedBoolean skeletonSkull;
    private static boolean loaded;
    private static Runnable updateJEI;

    public static void setJEIUpdateRunnable(Runnable runnable) {
        updateJEI = runnable;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void configChanged(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals("inspirations")) {
            ForgeConfigSpec spec = config.getSpec();
            if (spec == SERVER_SPEC) {
                SERVER_VALUES.forEach(CachedValue::invalidate);
                loaded = true;
                InspirationsRegistry.setBookKeywords(Arrays.stream(((String)bookKeywords.get()).split(",")).map(String::trim).collect(Collectors.toList()));
                if (updateJEI != null) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().func_213165_a(updateJEI));
                }
            } else if (spec == CLIENT_SPEC) {
                CLIENT_VALUES.forEach(CachedValue::invalidate);
            }
        }
    }

    private static <T> CachedValue<T> server(ForgeConfigSpec.ConfigValue<T> value) {
        CachedValue cached = new CachedValue(value);
        SERVER_VALUES.add(cached);
        return cached;
    }

    private static CachedBoolean server(ForgeConfigSpec.BooleanValue value) {
        CachedBoolean cached = new CachedBoolean((ForgeConfigSpec.ConfigValue)value);
        SERVER_VALUES.add((CachedValue<?>)cached);
        return cached;
    }

    private static CachedBoolean client(ForgeConfigSpec.BooleanValue value) {
        CachedBoolean cached = new CachedBoolean((ForgeConfigSpec.ConfigValue)value);
        CLIENT_VALUES.add((CachedValue<?>)cached);
        return cached;
    }

    private static CachedBoolean and(CachedBoolean first, ForgeConfigSpec.BooleanValue second) {
        CachedBoolean cached = new CachedBoolean(() -> (Boolean)first.get() != false && (Boolean)second.get() != false);
        SERVER_VALUES.add((CachedValue<?>)cached);
        return cached;
    }

    private static CachedBoolean and(CachedBoolean first, CachedBoolean second) {
        CachedBoolean cached = new CachedBoolean(() -> (Boolean)first.get() != false && (Boolean)second.get() != false);
        SERVER_VALUES.add((CachedValue<?>)cached);
        return cached;
    }

    private static CachedBoolean and(CachedBoolean first, CachedBoolean second, ForgeConfigSpec.BooleanValue third) {
        CachedBoolean cached = new CachedBoolean(() -> (Boolean)first.get() != false && (Boolean)second.get() != false && (Boolean)third.get() != false);
        SERVER_VALUES.add((CachedValue<?>)cached);
        return cached;
    }

    private static CachedBoolean override(ForgeConfigSpec.BooleanValue value) {
        return new CachedBoolean((ForgeConfigSpec.ConfigValue)value);
    }

    private static CachedBoolean andOverride(CachedBoolean first, ForgeConfigSpec.BooleanValue second) {
        return new CachedBoolean(() -> (Boolean)first.get() != false && (Boolean)second.get() != false);
    }

    static {
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder client = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder override = new ForgeConfigSpec.Builder();
        server.push("modules");
        buildingModule = Config.server(server.comment("Building blocks to improve decoration").worldRestart().define("building", true));
        utilityModule = Config.server(server.comment("Adds tools for automation and redstone interaction").worldRestart().define("utility", true));
        tweaksModule = Config.server(server.comment("Contains tweaks to vanilla features").worldRestart().define("tweaks", true));
        toolsModule = Config.server(server.comment("Includes new tools to reduce dependency on debug features").worldRestart().define("tools", true));
        recipesModule = Config.server(server.comment("Includes new blocks that add new types of recipes").worldRestart().define("tools", true));
        server.pop();
        showAllVariants = Config.server(server.comment("Shows all variants for dynamically textured blocks, like bookshelves. If false just the first will be shown").define("general.showAllVariants", true));
        server.push("building");
        enableBookshelf = Config.and(buildingModule, server.comment("Enables the shelf: a decorative block to display books and other items").worldRestart().define("bookshelf.enable", true));
        enableColoredBooks = Config.and(enableBookshelf, server.comment("Enables colored books: basically colored versions of the vanilla book to decorate shelves").worldRestart().define("bookshelf.coloredBooks", true));
        bookshelvesBoostEnchanting = Config.and(buildingModule, server.comment("If true, shelves will increase enchanting table power.").define("bookshelf.boostEnchanting", true));
        defaultEnchantingPower = Config.server(server.comment("Default power for a book for enchanting, can be overridden in the book overrides.").defineInRange("bookshelf.defaultEnchanting", 1.5, 0.0, 15.0));
        bookKeywords = Config.server(server.comment("List of keywords for valid books, used to determine books in the shelf (non-books take more space). Separate each by commas.").define("bookshelf.bookKeywords", (Object)BOOK_KEYWORD_DEFAULTS));
        enableRope = Config.and(buildingModule, server.comment("Enables rope: can be climbed like ladders and extended with additional rope").worldRestart().define("rope", true));
        enableRopeLadder = Config.and(enableRope, server.comment("Enables rope ladders: right click ropes with sticks to extend the hitbox").define("ropeLadder", true));
        climbableIronBars = Config.override(override.comment("Makes iron bars climbable if a rope is below them.").worldRestart().define("climbableBars", true));
        enableGlassDoor = Config.and(buildingModule, server.comment("Enables glass doors and trapdoors: basically doors, but made of glass. Not sure what you would expect.").worldRestart().define("glassDoor", true));
        enableMulch = Config.and(buildingModule, server.comment("Enables mulch: a craftable falling block which supports plants such as flowers").worldRestart().define("mulch", true));
        enablePath = Config.and(buildingModule, server.comment("Enables stone paths: a carpet like decorative block for making decorative paths").worldRestart().define("path", true));
        enableFlowers = Config.and(buildingModule, server.comment("Enables additional flowers from breaking double flowers with shears.").worldRestart().define("flowers", true));
        enableEnlightenedBush = Config.and(buildingModule, server.comment("Enables enlightened bushes: bushes with lights.").worldRestart().define("enlightenedBush", true));
        server.pop();
        server.push("utility");
        enableRedstoneBook = Config.and(utilityModule, enableBookshelf, server.comment("Enables the trapped book: will emit redstone power when placed in a bookshelf. Requires bookshelf.").worldRestart().define("redstoneBook", true));
        enableTorchLever = Config.and(utilityModule, server.comment("Enables the torch lever: basically a lever which looks like a torch").worldRestart().define("torchLever", true));
        enableCarpetedTrapdoor = Config.and(utilityModule, server.comment("Enables carpeted trapdoors: a trapdoor which appears to be a carpet when closed").worldRestart().define("carpetedTrapdoor", true));
        enableCarpetedPressurePlate = Config.and(utilityModule, server.comment("Allows placing a carpet on a stone pressure plate to hide it").worldRestart().define("carpetedPressurePlate", true));
        enableCollector = Config.and(utilityModule, server.comment("Enables the collector: extracts items from inventories or the world similar to a hopper, but can face in all 6 directions and cannot place items in inventories").worldRestart().define("collector", true));
        enablePipe = Config.and(utilityModule, server.comment("Enables pipes: a more economical hopper that only outputs items, does not pull from inventories. Both cheaper and better for performance.").worldRestart().define("pipe.enable", true));
        pipeUpwards = Config.server(server.comment("Allows pipes to output upwards. This removes a limitation on not being able to pipe items up without dropper elevators, but should be balanced alongside modded pipes.").define("pipe.upwards", true));
        server.pop();
        server.push("recipes");
        extendedCauldron = Config.override(override.comment("Replace the cauldron block to allow it to hold other liquids and perform extended recipes.").worldRestart().define("cauldron", true));
        server.push("cauldron");
        cauldronRecipes = Config.and(recipesModule, server.comment("Allows additional recipes to be performed in the cauldron. If the block replacement is disabled, functionality will be limited to water in cauldrons.").define("enable", true));
        extendedCaulronRecipes = Config.and(extendedCauldron, cauldronRecipes);
        cauldronConcrete = Config.and(cauldronRecipes, server.comment("Allows concrete to be made in the cauldron").define("concrete", true));
        cauldronIce = Config.and(extendedCaulronRecipes, server.comment("If true, the cauldron can be used to make ice when in a cold biome or surrounded with ice").define("ice", true));
        enableCauldronFluids = Config.and(extendedCaulronRecipes, server.comment("Allows cauldrons to be filled with any fluid and use them in recipes").define("fluids.enable", true));
        enableCauldronDyeing = Config.and(extendedCaulronRecipes, server.comment("Allows cauldrons to be filled with dyes and dye items using cauldrons").define("dyeing.enable", true));
        extraBottleRecipes = Config.and(enableCauldronDyeing, server.comment("Adds extra dyed bottle recipes to craft green and brown").define("dyeing.extraBottleRecipes", true));
        enableCauldronPotions = Config.and(cauldronRecipes, extendedCauldron, server.comment("Allows cauldrons to be filled with potions and support brewing").define("potions.enable", true));
        enableCauldronBrewing = Config.and(enableCauldronPotions, server.comment("Allows cauldrons to perform brewing recipes.").define("potions.brewing", true));
        cauldronTipArrows = Config.and(enableCauldronPotions, server.comment("Allows cauldrons to tip arrows with potions.").define("potions.tippedArrow", true));
        fasterCauldronRain = Config.and(recipesModule, extendedCauldron, server.comment("If true, cauldrons fill faster in the rain.").define("fasterRain", true));
        server.pop();
        server.pop();
        server.push("tools");
        enableRedstoneCharger = Config.and(toolsModule, server.comment("Enables the redstone charger: a quick pulse created with a flint and steel like item").worldRestart().define("redstoneCharger", true));
        enableChargedArrow = Config.and(toolsModule, server.comment("Enables the charged arrow: places a redstone pulse where it lands").worldRestart().define("chargedArrow", true));
        enableLock = Config.and(toolsModule, server.comment("Enables locks and keys: an item allowing you to lock a tile entity to only open for a special named item").worldRestart().define("lock", true));
        harvestHangingVines = Config.and(toolsModule, server.comment("When shearing vines, any supported vines will also be sheared instead of just broken").define("shears.harvestHangingVines", true));
        shearsReclaimMelons = Config.and(toolsModule, server.comment("Breaking a melon block with shears will always return 9 slices").define("reclaimMelons", true));
        enableNorthCompass = Config.and(toolsModule, server.comment("Enables the north compass: a cheaper compass that always points north. Intended to either allow packs to replace the compass or as an alternative for F3 navigation").worldRestart().define("northCompass.enable", true));
        enableBarometer = Config.and(toolsModule, server.comment("Enables the barometer: a tool to measure the player's height in world.").worldRestart().define("barometer", true));
        enablePhotometer = Config.and(toolsModule, server.comment("Enables the photometer: a tool to measure light in world. Can be pointed at a block to measure the light level of that block.").worldRestart().define("photometer", true));
        enableDimensionCompass = Config.and(toolsModule, server.comment(new String[]{"Enables the dimension compass: a compass which points towards the place you entered a dimension.", "When used on a lodestone, works across dimensions taking nether coordinates into account"}).worldRestart().define("dimensionCompass.enable", true));
        moreShieldEnchantments = Config.server(override.comment("If true, shields can now be enchanted with enchantments such as protection, fire aspect, knockback, and thorns. This requires replacing these enchantments.").worldRestart().define("enchantments.moreShield", true));
        shieldEnchantmentTable = Config.andOverride(moreShieldEnchantments, override.comment("If true, shields can be enchanted in an enchantment table. Does not support modded shields as it requires a registry substitution").worldRestart().define("enchantments.shieldTable", true));
        fixShieldTooltip = Config.and(toolsModule, server.comment("If true, fixes the tooltip on shield items so it looks better with both patterns and enchantments").worldRestart().define("enchantments.fixShieldTooltip", true));
        axeWeaponEnchants = Config.server(override.comment("If true, axes will be able to be enchanted with weapon enchants such as looting, fire aspect, and knockback").worldRestart().define("enchantments.axeWeapon", true));
        axeEnchantmentTable = Config.server(override.comment("If true, axes can receive available weapon enchantments at the enchantment table").worldRestart().define("enchantments.axeTable", true));
        server.pop();
        server.push("tweaks");
        enablePigDesaddle = Config.and(tweaksModule, server.comment("Allows pigs to be desaddled by shift-right click with an empty hand").define("desaddlePig", true));
        enableFittedCarpets = Config.override(override.comment("Replace carpet blocks, allowing them to fit to stairs below them.").worldRestart().define("fittedCarpets", true));
        waterlogHopper = Config.override(override.comment("Replace hopper blocks, allowing them to be waterlogged.").worldRestart().define("waterlogHoppers", true));
        server.push("bonemeal");
        bonemealMushrooms = Config.and(tweaksModule, server.comment("Bonemeal can be used on mycelium to produce mushrooms").define("mushrooms", true));
        bonemealDeadBush = Config.and(tweaksModule, server.comment("Bonemeal can be used on sand to produce dead bushes").define("deadBush", true));
        bonemealGrassSpread = Config.and(tweaksModule, server.comment("Bonemeal can be used on dirt to produce grass if adjecent to grass").define("grassSpread", true));
        bonemealMyceliumSpread = Config.and(tweaksModule, server.comment("Bonemeal can be used on dirt to produce mycelium if adjecent to mycelium").define("myceliumSpread", true));
        server.pop();
        enableHeartbeet = Config.and(tweaksModule, server.comment("Enables heartbeets: a rare drop from beetroots which can be eaten to restore a bit of health").worldRestart().define("heartbeet.enable", true));
        brewHeartbeet = Config.and(enableHeartbeet, server.comment("Allows heartbeets to be used as an alternative to ghast tears in making potions of regeneration").worldRestart().define("heartbeet.brewRegeneration", true));
        dispensersPlaceAnvils = Config.and(tweaksModule, server.comment("Dispensers will place anvils instead of dropping them. Plays well with anvil smashing.").worldRestart().define("dispensersPlaceAnvils", true));
        lilypadBreakFall = Config.and(tweaksModule, server.comment("Lily pads prevent fall damage, but break in the process").define("lilypadBreakFall", true));
        unstackableRecipeAlts = Config.and(tweaksModule, server.comment("Adds stackable recipes to some vanilla or Inspriations items that require unstackable items to craft").worldRestart().define("unstackableRecipeAlts", true));
        caveSpiderDrops = Config.and(tweaksModule, server.comment("If true, cave spiders will rarely drop webs, giving them an advantage to farm over regular spiders").define("caveSpiderWeb", true));
        skeletonSkull = Config.and(tweaksModule, server.comment("If true, skeletons will rarely drop their skull for consistency with wither skeletons. Does not affect creeper or zombie heads.").define("skeletonSkull", true));
        milkCooldown = Config.server(server.comment("Adds a cooldown to milking cows, prevents practically infinite milk in modded worlds where milk is more useful.").define("milkCooldown.enable", false));
        milkCooldownTime = Config.server(server.comment("Delay in seconds after milking a cow before it can be milked again.").defineInRange("milkCooldown.time", 600, 1, Short.MAX_VALUE));
        server.push("seeds");
        server.push("blockCrops");
        enableBlockCrops = Config.and(tweaksModule, server.comment("If true, adds seeds for cactus and sugar cane, useful for recipes for the crops").worldRestart().define("enable", true));
        smoothBlockCropGrowth = Config.and(enableBlockCrops, server.comment("If true, cactus and sugar cane will grow in 2 pixel increments using the block crops").define("smoothGrowth", true));
        bonemealBlockCrop = Config.and(tweaksModule, server.comment("If true, allows bonemeal to be used to speed block crop growth").define("bonemeal", false));
        nerfCactusFarms = Config.server(server.comment(new String[]{"If false, cactus seeds planted on cactus have fewer restrictions.", "Setting to true means cactus seeds are broken by neighboring blocks, meaning classic cactus farms will drop cactus seeds instead of full cactus."}).define("nerfCactusFarms", false));
        server.pop();
        server.pop();
        server.pop();
        betterCauldronItem = Config.client(client.comment("Replaces the flat cauldron sprite with the 3D cauldron block model").define("betterCauldronItemModel", true));
        coloredFireworkItems = Config.client(client.comment("Colors the fireworks item based on the colors of the stars").worldRestart().define("coloredFireworkItems", true));
        coloredEnchantedRibbons = Config.client(client.comment("The ribbon on enchanted books colors based on the enchantment rarity").worldRestart().define("coloredEnchantedRibbons", true));
        customPortalColor = Config.client(client.comment("Allows the portal color to be changed by placing colored blocks under the portal. Any block that tints a beacon beam will work for the color.").worldRestart().define("customPortalColor", true));
        SERVER_SPEC = server.build();
        CLIENT_SPEC = client.build();
        OVERRIDE_SPEC = override.build();
        loaded = false;
        updateJEI = null;
    }
}

