/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.datagen;

import java.util.Objects;
import java.util.stream.Collectors;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.loot.RetexturedLootFunction;

public class InspirationsBlockLootTable
extends BlockLootTables {
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> {
            String ns = Objects.requireNonNull(block.getRegistryName()).func_110624_b();
            return ns.equals("inspirations") || ns.equals("minecraft");
        }).collect(Collectors.toList());
    }

    protected void addTables() {
        super.addTables();
        this.addBuilding();
        this.addTools();
        this.addTweaks();
        this.addUtility();
    }

    private void addBuilding() {
        InspirationsBuilding.shelf.values().forEach(block -> this.func_218522_a((Block)block, this::droppingWithNameAndTexture));
        InspirationsBuilding.enlightenedBush.values().forEach(block -> this.func_218522_a((Block)block, this::enlightenedBush));
        InspirationsBuilding.mulch.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).func_218492_c(arg_0));
        InspirationsBuilding.path.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).func_218492_c(arg_0));
        this.func_218466_b(InspirationsBuilding.glassTrapdoor);
        this.func_218507_a(InspirationsBuilding.glassDoor, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)InspirationsBuilding.glassDoor)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)InspirationsBuilding.glassDoor).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER))).func_212840_b_(field_218573_a)));
        InspirationsBuilding.flower.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).func_218492_c(arg_0));
        InspirationsBuilding.flowerPot.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).func_218547_a(arg_0));
        this.func_218522_a(InspirationsBuilding.rope, this::rope);
        this.func_218522_a(InspirationsBuilding.vine, this::rope);
    }

    private void addTools() {
        this.func_218507_a(InspirationsTools.redstoneCharge, InspirationsBlockLootTable.func_218482_a());
    }

    private void addTweaks() {
        if (((Boolean)Config.enableFittedCarpets.get()).booleanValue()) {
            for (DyeColor color : DyeColor.values()) {
                this.registerRedirect((Block)InspirationsTweaks.fitCarpets.get((Enum)color), (Block)InspirationsTweaks.flatCarpets.get((Enum)color));
            }
        }
        this.func_218507_a((Block)InspirationsTweaks.wetHopper, InspirationsBlockLootTable.func_218481_e((Block)InspirationsTweaks.dryHopper));
        this.func_218493_a((Block)InspirationsTweaks.sugarCane, (IItemProvider)InspirationsTweaks.sugarCaneSeeds);
        this.func_218493_a((Block)InspirationsTweaks.cactus, (IItemProvider)InspirationsTweaks.cactusSeeds);
    }

    private void addUtility() {
        InspirationsUtility.carpetedTrapdoors.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).func_218492_c(arg_0));
        InspirationsUtility.carpetedPressurePlates.forEach((color, plate) -> this.func_218507_a((Block)plate, LootTable.func_216119_b().func_216040_a((LootPool.Builder)InspirationsBlockLootTable.func_218560_a((IItemProvider)plate, (ILootConditionConsumer)LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)plate.getCarpet())))).func_216040_a((LootPool.Builder)InspirationsBlockLootTable.func_218560_a((IItemProvider)plate, (ILootConditionConsumer)LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_221748_cj))))));
        this.func_218492_c(InspirationsUtility.pipe);
        this.func_218492_c(InspirationsUtility.collector);
        this.func_218493_a(InspirationsUtility.torchLeverFloor, (IItemProvider)InspirationsUtility.torchLeverItem);
        this.func_218493_a(InspirationsUtility.soulLeverFloor, (IItemProvider)InspirationsUtility.soulLeverItem);
    }

    private LootTable.Builder rope(Block block) {
        RopeBlock rope = (RopeBlock)block;
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)InspirationsBlockLootTable.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)))).func_216040_a((LootPool.Builder)InspirationsBlockLootTable.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)rope.getRungsItem()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)4)))).func_212840_b_(BlockStateProperty.func_215985_a((Block)rope).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.NONE))).func_216298_a())));
    }

    private LootTable.Builder enlightenedBush(Block bush) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)bush).func_212841_b_(RetexturedLootFunction::new)).func_212840_b_(field_218576_d));
    }

    private LootTable.Builder droppingWithNameAndTexture(Block block) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)InspirationsBlockLootTable.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_(RetexturedLootFunction::new))));
    }

    private void registerRedirect(Block block, Block originalBlock) {
        this.func_218507_a(block, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)originalBlock.func_220068_i()))));
    }
}

