/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.network.CauldronStateUpdatePacket;
import knightminer.inspirations.common.network.CauldronTransformUpatePacket;
import knightminer.inspirations.common.network.DimensionCompassPositionPacket;
import knightminer.inspirations.common.network.InventorySlotSyncPacket;
import knightminer.inspirations.common.network.MilkablePacket;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;

public class InspirationsNetwork
extends NetworkWrapper {
    public static final InspirationsNetwork INSTANCE = new InspirationsNetwork();

    private InspirationsNetwork() {
        super(Inspirations.getResource("network"));
    }

    public void setup() {
        this.registerPacket(InventorySlotSyncPacket.class, InventorySlotSyncPacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(MilkablePacket.class, MilkablePacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(CauldronStateUpdatePacket.class, CauldronStateUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(CauldronTransformUpatePacket.class, CauldronTransformUpatePacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(DimensionCompassPositionPacket.class, DimensionCompassPositionPacket::new, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendPacket(Entity player, IPacket<?> packet) {
        INSTANCE.sendVanillaPacket(packet, player);
    }

    public static void sendToClients(@Nullable World world, BlockPos pos, ISimplePacket packet) {
        if (world instanceof ServerWorld) {
            InspirationsNetwork.sendToClients((ServerWorld)world, pos, packet);
        }
    }

    public static void sendToClients(ServerWorld world, BlockPos pos, ISimplePacket packet) {
        INSTANCE.sendToClientsAround(packet, world, pos);
    }
}

