/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class InventorySlotSyncPacket
implements IThreadsafePacket {
    private final ItemStack itemStack;
    private final int slot;
    private final BlockPos pos;

    public InventorySlotSyncPacket(ItemStack itemStack, int slot, BlockPos pos) {
        this.itemStack = itemStack;
        this.pos = pos;
        this.slot = slot;
    }

    public InventorySlotSyncPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.slot = buf.readShort();
        this.itemStack = buf.func_150791_c();
    }

    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeShort(this.slot);
        buf.writeItemStack(this.itemStack, false);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(InventorySlotSyncPacket packet) {
            assert (Minecraft.func_71410_x().field_71441_e != null);
            TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.pos);
            if (tileEntity != null) {
                tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(handler -> handler instanceof IItemHandlerModifiable).ifPresent(handler -> {
                    ((IItemHandlerModifiable)handler).setStackInSlot(packet.slot, packet.itemStack);
                    Minecraft.func_71410_x().field_71438_f.func_184376_a(null, packet.pos, null, null, 3);
                    ModelDataManager.requestModelDataRefresh((TileEntity)tileEntity);
                });
            }
        }
    }
}

