/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.recipes.recipe.cauldron.contents.ColorContentType;
import knightminer.inspirations.recipes.recipe.cauldron.contents.CustomContentType;
import knightminer.inspirations.recipes.recipe.cauldron.contents.DyeContentType;
import knightminer.inspirations.recipes.recipe.cauldron.contents.FluidContentType;
import knightminer.inspirations.recipes.recipe.cauldron.contents.PotionContentType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;

public class CauldronContentTypes {
    private static final ResourceLocation UNREGISTERED = Inspirations.getResource("null");
    public static final String KEY_TYPE = "type";
    private static final BiMap<ResourceLocation, CauldronContentType<?>> TYPES = HashBiMap.create();
    public static final CauldronContentType<Fluid> FLUID = CauldronContentTypes.register("fluid", new FluidContentType());
    public static final CauldronContentType<Integer> COLOR = CauldronContentTypes.register("color", new ColorContentType());
    public static final CauldronContentType<DyeColor> DYE = CauldronContentTypes.register("dye", new DyeContentType());
    public static final CauldronContentType<Potion> POTION = CauldronContentTypes.register("potion", new PotionContentType(Inspirations.getResource("potion"), false));
    public static final CauldronContentType<Potion> UNFERMENTED_POTION = CauldronContentTypes.register("unfermented_potion", new PotionContentType(Inspirations.getResource("unfermented_potion"), true));
    public static final CauldronContentType<ResourceLocation> CUSTOM = CauldronContentTypes.register("custom", new CustomContentType());
    public static final Lazy<ICauldronContents> DEFAULT = Lazy.of(() -> FLUID.of((Fluid)Fluids.field_204546_a));

    public static void register(ResourceLocation name, CauldronContentType<?> type) {
        if (UNREGISTERED.equals((Object)name) || TYPES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Duplicate cauldron content type '" + name + "'");
        }
        TYPES.put((Object)name, type);
    }

    @Nullable
    public static CauldronContentType<?> get(ResourceLocation name) {
        return (CauldronContentType)TYPES.get((Object)name);
    }

    private static <T extends CauldronContentType<?>> T register(String name, T type) {
        CauldronContentTypes.register(Inspirations.getResource(name), type);
        return type;
    }

    public static ResourceLocation getName(CauldronContentType<?> type) {
        ResourceLocation name = (ResourceLocation)TYPES.inverse().get(type);
        if (name == null) {
            return UNREGISTERED;
        }
        return name;
    }

    private static <T, D> ICauldronContents read(CauldronContentType<T> type, D data, BiFunction<CauldronContentType<T>, D, T> parser) {
        T value = parser.apply(type, data);
        if (value == null) {
            return (ICauldronContents)DEFAULT.get();
        }
        return type.of(value);
    }

    public static ICauldronContents read(JsonObject json) {
        ResourceLocation location = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)KEY_TYPE));
        CauldronContentType<?> type = CauldronContentTypes.get(location);
        if (type != null) {
            return CauldronContentTypes.read(type, json, CauldronContentType::read);
        }
        throw new JsonSyntaxException("Invalid cauldron content type '" + location + "'");
    }

    public static ICauldronContents read(CompoundNBT nbt) {
        ResourceLocation location;
        CauldronContentType<?> type;
        if (nbt.func_150297_b(KEY_TYPE, 8) && (type = CauldronContentTypes.get(location = new ResourceLocation(nbt.func_74779_i(KEY_TYPE)))) != null) {
            return CauldronContentTypes.read(type, nbt, CauldronContentType::read);
        }
        return (ICauldronContents)DEFAULT.get();
    }

    public static ICauldronContents read(PacketBuffer buffer) {
        ResourceLocation name = buffer.func_192575_l();
        CauldronContentType<?> type = CauldronContentTypes.get(name);
        if (type == null) {
            throw new DecoderException("Invalid type name '" + name + "'");
        }
        return CauldronContentTypes.read(type, buffer, CauldronContentType::read);
    }
}

