/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronIngredients;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.ingredient.ICauldronIngredient;
import knightminer.inspirations.library.recipe.cauldron.recipe.CauldronRecipeBuilder;
import knightminer.inspirations.library.recipe.cauldron.util.LevelPredicate;
import knightminer.inspirations.library.recipe.cauldron.util.TemperaturePredicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;

public class CauldronTransformBuilder
extends AbstractRecipeBuilder<CauldronTransformBuilder> {
    private final ICauldronIngredient ingredient;
    private final ICauldronContents output;
    private final int time;
    @Nullable
    private LevelPredicate level;
    private TemperaturePredicate temperature = TemperaturePredicate.ANY;
    @Nullable
    private SoundEvent sound = null;

    private CauldronTransformBuilder(ICauldronIngredient ingredient, ICauldronContents output, int time) {
        this.ingredient = ingredient;
        this.output = output;
        this.time = time;
    }

    public static CauldronTransformBuilder transform(ICauldronIngredient ingredient, ICauldronContents output, int time) {
        if (time <= 0) {
            throw new IllegalArgumentException("Time must be greater than zero");
        }
        return new CauldronTransformBuilder(ingredient, output, time);
    }

    public CauldronTransformBuilder setTemperature(TemperaturePredicate temp) {
        this.temperature = temp;
        return this;
    }

    public CauldronTransformBuilder minLevels(int min) {
        if (min <= 0) {
            throw new IllegalArgumentException("Cannot match 0 levels");
        }
        this.level = LevelPredicate.min(min);
        return this;
    }

    public CauldronTransformBuilder maxLevels(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("Cannot match 0 levels");
        }
        this.level = LevelPredicate.range(1, max);
        return this;
    }

    public CauldronTransformBuilder matchFull() {
        return this.minLevels(12);
    }

    public CauldronTransformBuilder levelRange(int min, int max) {
        if (min <= 0) {
            throw new IllegalArgumentException("Cannot match 0 levels");
        }
        this.level = LevelPredicate.range(min, max);
        return this;
    }

    public CauldronTransformBuilder setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation name = CauldronRecipeBuilder.nameFromContents(this.output);
        if (name != null) {
            this.build(consumer, name);
        }
        throw new IllegalStateException("Unable to create automatic recipe ID");
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildAdvancement(id, "cauldron");
        consumer.accept(new Result(id, this.group, this.ingredient, this.level, this.temperature, this.output, this.time, this.sound, this.advancementBuilder, advancementId));
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final ICauldronIngredient ingredient;
        @Nullable
        private final LevelPredicate level;
        private final TemperaturePredicate temperature;
        private final ICauldronContents output;
        private final int time;
        @Nullable
        private final SoundEvent sound;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        private Result(ResourceLocation id, String group, ICauldronIngredient ingredient, @Nullable LevelPredicate level, TemperaturePredicate temperature, ICauldronContents output, int time, @Nullable SoundEvent sound, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.level = level;
            this.temperature = temperature;
            this.output = output;
            this.time = time;
            this.sound = sound;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("input", (JsonElement)CauldronIngredients.toJson(this.ingredient));
            if (this.level != null) {
                json.add("level", (JsonElement)this.level.toJson());
            }
            if (this.temperature != TemperaturePredicate.ANY) {
                json.addProperty("temperature", this.temperature.getName());
            }
            json.add("output", (JsonElement)this.output.toJson());
            json.addProperty("time", (Number)this.time);
            if (this.sound != null) {
                json.addProperty("sound", Objects.requireNonNull(this.sound.getRegistryName()).toString());
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return RecipeSerializers.CAULDRON_TRANSFORM;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

