/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron.util;

import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;

public enum TemperaturePredicate implements Predicate<CauldronTemperature>
{
    ANY{

        @Override
        public boolean test(CauldronTemperature temperature) {
            return true;
        }
    }
    ,
    BOILING{

        @Override
        public boolean test(CauldronTemperature temperature) {
            return temperature == CauldronTemperature.BOILING;
        }
    }
    ,
    FREEZING{

        @Override
        public boolean test(CauldronTemperature temperature) {
            return temperature == CauldronTemperature.FREEZING;
        }
    }
    ,
    NORMAL{

        @Override
        public boolean test(CauldronTemperature temperature) {
            return temperature == CauldronTemperature.NORMAL;
        }
    }
    ,
    WARM{

        @Override
        public boolean test(CauldronTemperature temperature) {
            return temperature != CauldronTemperature.FREEZING;
        }
    }
    ,
    COOL{

        @Override
        public boolean test(CauldronTemperature temperature) {
            return temperature != CauldronTemperature.BOILING;
        }
    };

    private final String name = this.name().toLowerCase(Locale.US);

    public String getName() {
        return this.name;
    }

    @Nullable
    public static TemperaturePredicate byName(String name) {
        for (TemperaturePredicate boiling : TemperaturePredicate.values()) {
            if (!boiling.getName().equals(name)) continue;
            return boiling;
        }
        return null;
    }
}

