/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.inspirations.library.recipe.RecipeSerializers;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.inventory.ICauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.inventory.IModifyableCauldronInventory;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.DisplayCauldronRecipe;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.item.MixedDyedBottleItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.IMultiRecipe;

public class FillDyedBottleRecipe
implements ICauldronRecipe,
IMultiRecipe<DisplayCauldronRecipe> {
    private final ResourceLocation id;
    private List<DisplayCauldronRecipe> displayRecipes;

    public FillDyedBottleRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(ICauldronInventory inv, World worldIn) {
        return inv.getLevel() >= 4 && inv.getStack().func_77973_b() == Items.field_151069_bo && inv.getContents().contains(CauldronContentTypes.COLOR);
    }

    @Override
    public void handleRecipe(IModifyableCauldronInventory inventory) {
        inventory.getContents().get(CauldronContentTypes.COLOR).ifPresent(color -> {
            inventory.shrinkStack(1);
            inventory.setOrGiveStack(MixedDyedBottleItem.bottleFromDye(color));
            inventory.addLevel(-4);
            inventory.playSound(SoundEvents.field_187615_H);
        });
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.CAULDRON_FILL_DYED_BOTTLE;
    }

    public List<DisplayCauldronRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<ItemStack> glassBottle = Collections.singletonList(new ItemStack((IItemProvider)Items.field_151069_bo));
            this.displayRecipes = Arrays.stream(DyeColor.values()).map(color -> DisplayCauldronRecipe.builder(4, 0).setItemInputs(glassBottle).setContentInputs(CauldronContentTypes.DYE.of((DyeColor)color)).setItemOutput((IItemProvider)InspirationsRecipes.simpleDyedWaterBottle.get((Enum)color)).build()).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }
}

