/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron.contents;

import java.util.List;
import javax.annotation.Nullable;
import knightminer.inspirations.library.recipe.cauldron.contents.RegistryContentType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionContentType
extends RegistryContentType<Potion> {
    private static final String PREFIX = "item.minecraft.potion.effect.";
    private final ResourceLocation textureName;
    @Nullable
    private final String wrapName;

    public PotionContentType(ResourceLocation textureName, boolean wrapName) {
        super(ForgeRegistries.POTION_TYPES);
        this.textureName = textureName;
        this.wrapName = wrapName ? Util.func_200697_a((String)"cauldron_contents", (ResourceLocation)textureName) : null;
    }

    @Override
    public ResourceLocation getTexture(Potion value) {
        return this.textureName;
    }

    @Override
    public int getColor(Potion value) {
        return PotionUtils.func_185183_a((Potion)value);
    }

    @Override
    public ITextComponent getDisplayName(Potion value) {
        TranslationTextComponent component = new TranslationTextComponent(value.func_185174_b(PREFIX));
        if (this.wrapName != null) {
            return new TranslationTextComponent(this.wrapName, new Object[]{component});
        }
        return component;
    }

    @Override
    public void addInformation(Potion potion, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        for (EffectInstance instance : potion.func_185170_a()) {
            TranslationTextComponent effectString = new TranslationTextComponent(instance.func_188419_a().func_76393_a());
            Effect effect = instance.func_188419_a();
            if (instance.func_76458_c() > 0) {
                effectString.func_240702_b_(" ");
                effectString.func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + instance.func_76458_c()));
            }
            if (instance.func_76459_b() > 20) {
                effectString.func_230529_a_((ITextComponent)new StringTextComponent(" (" + EffectUtils.func_188410_a((EffectInstance)instance, (float)1.0f) + ")"));
            }
            effectString.func_240699_a_(effect.func_188408_i() ? TextFormatting.BLUE : TextFormatting.RED);
            tooltip.add((ITextComponent)effectString);
        }
        if (this.wrapName != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.wrapName + ".tooltip").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }
}

