/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.inventory;

import java.util.Optional;
import java.util.function.Consumer;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.recipe.RecipeTypes;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.library.recipe.cauldron.recipe.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.util.CauldronTemperature;
import knightminer.inspirations.recipes.recipe.inventory.CauldronItemInventory;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class VanillaCauldronInventory
extends CauldronItemInventory {
    private final World world;
    private final BlockPos pos;
    private final BlockState state;
    private CauldronTemperature temperature;

    public VanillaCauldronInventory(World world, BlockPos pos, BlockState state, ItemStack stack, Consumer<ItemStack> itemSetter, Consumer<ItemStack> itemAdder) {
        super(stack, itemSetter, itemAdder);
        this.state = state;
        this.world = world;
        this.pos = pos;
    }

    public VanillaCauldronInventory(World world, BlockPos pos, BlockState state, ItemStack stack, Consumer<ItemStack> itemAdder) {
        this(world, pos, state, stack, EMPTY_CONSUMER, itemAdder);
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public void playSound(SoundEvent sound) {
        this.world.func_184133_a(null, this.pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public int getLevel() {
        return (Integer)this.state.func_177229_b((Property)CauldronBlock.field_176591_a) * 4;
    }

    @Override
    public void setLevel(int level) {
        level = MathHelper.func_76125_a((int)level, (int)0, (int)12) / 4;
        if ((Integer)this.state.func_177229_b((Property)CauldronBlock.field_176591_a) != level) {
            ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(this.world, this.pos, this.state, level);
        }
    }

    @Override
    public ICauldronContents getContents() {
        return (ICauldronContents)CauldronContentTypes.DEFAULT.get();
    }

    @Override
    public void setContents(ICauldronContents contents) {
        if (!contents.isSimple()) {
            Inspirations.log.error("Cannot set cauldron contents of vanilla cauldron to non-water " + contents);
        }
    }

    @Override
    public CauldronTemperature getTemperature() {
        if (this.temperature == null) {
            this.temperature = CauldronTileEntity.calcTemperature((IWorld)this.world, this.pos, CauldronTileEntity.isCauldronFire(this.world.func_180495_p(this.pos.func_177977_b())), CauldronTileEntity.isFreezing(this.world, this.pos));
        }
        return this.temperature;
    }

    public boolean handleRecipe() {
        Optional recipe = this.world.func_199532_z().func_215371_a(RecipeTypes.CAULDRON, (IInventory)this, this.world);
        if (recipe.isPresent()) {
            ((ICauldronRecipe)recipe.get()).handleRecipe(this);
            return true;
        }
        return false;
    }
}

