/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import java.util.function.Supplier;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.tools.ToolsEvents;
import knightminer.inspirations.tools.block.RedstoneChargeBlock;
import knightminer.inspirations.tools.capability.DimensionCompass;
import knightminer.inspirations.tools.datagen.ToolsRecipeProvider;
import knightminer.inspirations.tools.enchantment.AxeDamageEnchantment;
import knightminer.inspirations.tools.enchantment.AxeLootBonusEnchantment;
import knightminer.inspirations.tools.enchantment.ExtendedFireAspectEnchantment;
import knightminer.inspirations.tools.enchantment.ExtendedKnockbackEnchantment;
import knightminer.inspirations.tools.enchantment.ShieldProtectionEnchantment;
import knightminer.inspirations.tools.enchantment.ShieldThornsEnchantment;
import knightminer.inspirations.tools.entity.RedstoneArrow;
import knightminer.inspirations.tools.item.DimensionCompassItem;
import knightminer.inspirations.tools.item.EnchantableShieldItem;
import knightminer.inspirations.tools.item.RedstoneArrowItem;
import knightminer.inspirations.tools.item.RedstoneChargerItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.EntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

public class InspirationsTools
extends ModuleBase {
    public static final String pulseID = "InspirationsTools";
    public static Item lock;
    public static Item key;
    public static Item redstoneCharger;
    public static Item northCompass;
    public static Item barometer;
    public static Item photometer;
    public static ArrowItem redstoneArrow;
    static Item shield;
    public static Item dimensionCompass;
    public static Block redstoneCharge;
    public static EntityType<RedstoneArrow> entRSArrow;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ToolsEvents.class);
        DimensionCompass.register();
        this.registerDispenserBehavior();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryAdapter registry = new BlockRegistryAdapter(event.getRegistry());
        redstoneCharge = (Block)registry.register((IForgeRegistryEntry)new RedstoneChargeBlock(), "redstone_charge");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemRegistryAdapter registry = new ItemRegistryAdapter(event.getRegistry());
        Item.Properties materialsProps = new Item.Properties().func_200916_a(ItemGroup.field_78035_l);
        Item.Properties toolProps = new Item.Properties().func_200916_a(ItemGroup.field_78040_i);
        redstoneArrow = (ArrowItem)registry.register((IForgeRegistryEntry)new RedstoneArrowItem(toolProps), "charged_arrow");
        redstoneCharger = (Item)registry.register((IForgeRegistryEntry)new RedstoneChargerItem(), "redstone_charger");
        lock = (Item)registry.register((IForgeRegistryEntry)new HidableItem(materialsProps, (Supplier<Boolean>)Config.enableLock), "lock");
        key = (Item)registry.register((IForgeRegistryEntry)new HidableItem(materialsProps, (Supplier<Boolean>)Config.enableLock), "key");
        northCompass = (Item)registry.register((IForgeRegistryEntry)new HidableItem(toolProps, (Supplier<Boolean>)Config.enableNorthCompass), "north_compass");
        barometer = (Item)registry.register((IForgeRegistryEntry)new HidableItem(toolProps, (Supplier<Boolean>)Config.enableBarometer), "barometer");
        photometer = (Item)registry.register((IForgeRegistryEntry)new HidableItem(toolProps, (Supplier<Boolean>)Config.enablePhotometer), "photometer");
        dimensionCompass = (Item)registry.register((IForgeRegistryEntry)new DimensionCompassItem(toolProps), "dimension_compass");
        if (((Boolean)Config.shieldEnchantmentTable.get()).booleanValue()) {
            shield = (Item)registry.register((IForgeRegistryEntry)new EnchantableShieldItem(new Item.Properties().func_200918_c(Items.field_185159_cQ.func_77612_l()).func_200916_a(ItemGroup.field_78037_j)), (IForgeRegistryEntry)Items.field_185159_cQ);
        }
    }

    @SubscribeEvent
    void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        EntityTypeRegistryAdapter registry = new EntityTypeRegistryAdapter(event.getRegistry());
        entRSArrow = registry.register(EntityType.Builder.func_220322_a(RedstoneArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory((packet, world) -> new RedstoneArrow(entRSArrow, (World)world)), "redstone_arrow");
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new ToolsRecipeProvider(gen));
        }
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        EquipmentSlotType[] slots;
        RegistryAdapter registry = new RegistryAdapter(event.getRegistry());
        if (((Boolean)Config.moreShieldEnchantments.get()).booleanValue()) {
            slots = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
            for (ProtectionEnchantment ench : new ProtectionEnchantment[]{(ProtectionEnchantment)Enchantments.field_180310_c, (ProtectionEnchantment)Enchantments.field_77329_d, (ProtectionEnchantment)Enchantments.field_180308_g, (ProtectionEnchantment)Enchantments.field_185297_d}) {
                registry.register((IForgeRegistryEntry)new ShieldProtectionEnchantment(ench.func_77324_c(), ench.field_77356_a, slots), (IForgeRegistryEntry)ench);
            }
            registry.register((IForgeRegistryEntry)new ShieldThornsEnchantment(Enchantments.field_92091_k.func_77324_c(), slots), (IForgeRegistryEntry)Enchantments.field_92091_k);
        }
        if (((Boolean)Config.moreShieldEnchantments.get()).booleanValue() || ((Boolean)Config.axeWeaponEnchants.get()).booleanValue()) {
            slots = new EquipmentSlotType[]{EquipmentSlotType.MAINHAND};
            registry.register((IForgeRegistryEntry)new ExtendedKnockbackEnchantment(Enchantment.Rarity.UNCOMMON, slots), (IForgeRegistryEntry)Enchantments.field_180313_o);
            registry.register((IForgeRegistryEntry)new ExtendedFireAspectEnchantment(Enchantment.Rarity.RARE, slots), (IForgeRegistryEntry)Enchantments.field_77334_n);
            if (((Boolean)Config.axeWeaponEnchants.get()).booleanValue()) {
                registry.register((IForgeRegistryEntry)new AxeLootBonusEnchantment(Enchantment.Rarity.RARE, EnchantmentType.WEAPON, slots), (IForgeRegistryEntry)Enchantments.field_185304_p);
            }
        }
        if (((Boolean)Config.axeEnchantmentTable.get()).booleanValue()) {
            slots = new EquipmentSlotType[]{EquipmentSlotType.MAINHAND};
            registry.register((IForgeRegistryEntry)new AxeDamageEnchantment(Enchantment.Rarity.COMMON, 0, slots), (IForgeRegistryEntry)Enchantments.field_185302_k);
            registry.register((IForgeRegistryEntry)new AxeDamageEnchantment(Enchantment.Rarity.UNCOMMON, 1, slots), (IForgeRegistryEntry)Enchantments.field_185303_l);
            registry.register((IForgeRegistryEntry)new AxeDamageEnchantment(Enchantment.Rarity.UNCOMMON, 2, slots), (IForgeRegistryEntry)Enchantments.field_180312_n);
        }
    }

    private void registerDispenserBehavior() {
        DispenserBlock.func_199774_a((IItemProvider)redstoneArrow, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World world, IPosition position, ItemStack stack) {
                RedstoneArrow arrow = new RedstoneArrow(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)redstoneCharger, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                this.func_239796_a_(true);
                ServerWorld world = source.func_197524_h();
                Direction facing = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos pos = source.func_180699_d().func_177972_a(facing);
                if (world.func_180495_p(pos).func_196953_a((BlockItemUseContext)new DirectionalPlaceContext((World)world, pos, facing, ItemStack.field_190927_a, facing))) {
                    world.func_175656_a(pos, (BlockState)redstoneCharge.func_176223_P().func_206870_a((Property)RedstoneChargeBlock.FACING, (Comparable)facing));
                    if (stack.func_96631_a(1, world.field_73012_v, null)) {
                        stack.func_190920_e(0);
                    }
                } else {
                    this.func_239796_a_(false);
                }
                return stack;
            }
        });
    }
}

