/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.MilkablePacket;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.network.packet.ISimplePacket;

@Mod.EventBusSubscriber(modid="inspirations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TweaksEvents {
    @SubscribeEvent
    static void unsaddlePig(PlayerInteractEvent.EntityInteract event) {
        PigEntity pig;
        Entity target;
        if (!((Boolean)Config.enablePigDesaddle.get()).booleanValue()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (player.func_213453_ef() && stack.func_190926_b() && (target = event.getTarget()) instanceof PigEntity && (pig = (PigEntity)target).func_110257_ck()) {
            pig.field_234214_bx_.func_233619_a_(false);
            pig.field_70170_p.func_184148_a(player, pig.func_226277_ct_(), pig.func_226278_cu_(), pig.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Items.field_151141_av), (int)player.field_71071_by.field_70461_c);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void extraBonemeal(BonemealEvent event) {
        if (!(((Boolean)Config.bonemealMushrooms.get()).booleanValue() || ((Boolean)Config.bonemealDeadBush.get()).booleanValue() || ((Boolean)Config.bonemealGrassSpread.get()).booleanValue() || ((Boolean)Config.bonemealMyceliumSpread.get()).booleanValue())) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (((Boolean)Config.bonemealMushrooms.get()).booleanValue() && block == Blocks.field_150391_bh || ((Boolean)Config.bonemealDeadBush.get()).booleanValue() && block.func_203417_a((ITag)BlockTags.field_203436_u)) {
            TweaksEvents.bonemealPlants(block, world, pos);
            event.setResult(Event.Result.ALLOW);
        } else if ((((Boolean)Config.bonemealGrassSpread.get()).booleanValue() || ((Boolean)Config.bonemealMyceliumSpread.get()).booleanValue()) && block == Blocks.field_150346_d && TweaksEvents.bonemealDirt(world, pos)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private static void bonemealPlants(Block base, World world, BlockPos pos) {
        BlockPos up = pos.func_177984_a();
        BushBlock bush = (BushBlock)Blocks.field_196555_aI;
        BlockState state = bush.func_176223_P();
        boolean isMycelium = base == Blocks.field_150391_bh;
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos next = up;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    if (!world.func_175623_d(next) || world.field_73012_v.nextInt(128) != 0) continue block0;
                    if (isMycelium) {
                        bush = (BushBlock)(world.field_73012_v.nextInt(2) == 0 ? Blocks.field_150337_Q : Blocks.field_150338_P);
                        state = bush.func_176223_P();
                    }
                    if (!bush.func_196260_a(state, (IWorldReader)world, next)) continue block0;
                    world.func_175656_a(next, state);
                    continue block0;
                }
                if (world.func_180495_p((next = next.func_177982_a(world.field_73012_v.nextInt(3) - 1, (world.field_73012_v.nextInt(3) - 1) * world.field_73012_v.nextInt(3) / 2, world.field_73012_v.nextInt(3) - 1)).func_177977_b()).func_177230_c() != base || world.func_180495_p(next).func_215686_e((IBlockReader)world, next)) continue block0;
                ++j;
            }
        }
    }

    private static boolean bonemealDirt(World world, BlockPos pos) {
        if (world.func_201696_r(pos.func_177984_a()) < 9) {
            return false;
        }
        int grass = 0;
        int mycelium = 0;
        for (Direction side : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(side);
            BlockState state = world.func_180495_p(offset);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockReader)world, pos)) {
                state = world.func_180495_p(offset.func_177977_b());
                block = state.func_177230_c();
            } else if (block != Blocks.field_196658_i && block != Blocks.field_150391_bh) {
                state = world.func_180495_p(offset.func_177984_a());
                block = state.func_177230_c();
            }
            if (((Boolean)Config.bonemealGrassSpread.get()).booleanValue() && block == Blocks.field_196658_i) {
                ++grass;
                continue;
            }
            if (!((Boolean)Config.bonemealMyceliumSpread.get()).booleanValue() || block != Blocks.field_150391_bh) continue;
            ++mycelium;
        }
        if (grass == 0 && mycelium == 0) {
            return false;
        }
        if (world.field_73012_v.nextInt(5) > Math.max(grass, mycelium) - 1) {
            return true;
        }
        if (grass == mycelium && world.field_73012_v.nextBoolean()) {
            ++mycelium;
        }
        world.func_175656_a(pos, grass >= mycelium ? Blocks.field_196658_i.func_176223_P() : Blocks.field_150391_bh.func_176223_P());
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void onFall(LivingFallEvent event) {
        double z;
        if (!((Boolean)Config.lilypadBreakFall.get()).booleanValue()) {
            return;
        }
        if (event.getDistance() < 4.0f) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        Vector3d vec = entity.func_213303_ch();
        if (vec.field_72448_b % 1.0 > 0.09375) {
            return;
        }
        BlockPos blockPos = entity.func_233580_cy_();
        BlockPos[] posList = new BlockPos[4];
        int i = 0;
        posList[i++] = blockPos;
        double x = vec.field_72450_a % 1.0;
        if (x < 0.0) {
            x += 1.0;
        }
        if ((z = vec.field_72449_c % 1.0) < 0.0) {
            z += 1.0;
        }
        if (x > 0.7) {
            posList[i++] = blockPos.func_177974_f();
        } else if (x < 0.3) {
            posList[i++] = blockPos.func_177976_e();
        }
        if (z > 0.7) {
            posList[i++] = blockPos.func_177968_d();
            if (i == 3) {
                posList[i++] = posList[1].func_177968_d();
            }
        } else if (z < 0.3) {
            posList[i++] = blockPos.func_177978_c();
            if (i == 3) {
                posList[i++] = posList[1].func_177978_c();
            }
        }
        boolean safe = false;
        for (BlockPos pos : posList) {
            if (pos == null || world.func_180495_p(pos).func_177230_c() != Blocks.field_196651_dG) continue;
            world.func_175655_b(pos, true);
            safe = true;
        }
        if (safe) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent
    static void milkCow(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)Config.milkCooldown.get()).booleanValue()) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof CowEntity) || ((CowEntity)target).func_70631_g_()) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
        if (stack.func_77973_b().func_206844_a(InspirationsTags.Items.MILK_CONTAINERS)) {
            CompoundNBT tags = target.getPersistentData();
            if (tags.func_74765_d("milk_cooldown") > 0) {
                event.setCancellationResult(ActionResultType.PASS);
                event.setCanceled(true);
            } else {
                tags.func_74777_a("milk_cooldown", ((Integer)Config.milkCooldownTime.get()).shortValue());
                if (!event.getWorld().field_72995_K) {
                    InspirationsNetwork.sendToClients(event.getWorld(), target.func_233580_cy_(), (ISimplePacket)new MilkablePacket(target, false));
                }
            }
        }
    }
}

