/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.recipe;

import java.util.function.Supplier;
import knightminer.inspirations.common.IHidable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class NormalBrewingRecipe
implements IHidable,
IBrewingRecipe {
    private final Supplier<Boolean> enabled;
    private final Potion start;
    private final Ingredient catalyst;
    private final Potion output;

    public NormalBrewingRecipe(Potion start, Ingredient catalyst, Potion output, Supplier<Boolean> enabledFunc) {
        this.start = start;
        this.catalyst = catalyst;
        this.output = output;
        this.enabled = enabledFunc;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public Potion getStart() {
        return this.start;
    }

    public Potion getOutput() {
        return this.output;
    }

    public boolean isInput(ItemStack input) {
        Item item = input.func_77973_b();
        if (item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI) {
            return PotionUtils.func_185191_c((ItemStack)input) == this.start;
        }
        return false;
    }

    public boolean isIngredient(ItemStack ingredient) {
        return this.catalyst.test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (!this.isEnabled()) {
            return ItemStack.field_190927_a;
        }
        if (!this.catalyst.test(ingredient)) {
            return ItemStack.field_190927_a;
        }
        Item item = input.func_77973_b();
        if (this.isInput(input)) {
            return PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)item), (Potion)this.output);
        }
        return ItemStack.field_190927_a;
    }
}

