/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import java.util.Random;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.utility.tileentity.CollectorTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.InventoryBlock;

public class CollectorBlock
extends InventoryBlock
implements IHidable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;

    public CollectorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.5f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableCollector.get();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.shouldAddtoItemGroup(group)) {
            super.func_149666_a(group, stacks);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TRIGGERED});
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196010_d();
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_213453_ef()) {
            facing = facing.func_176734_d();
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public TileEntity createTileEntity(BlockState blockState, IBlockReader iBlockReader) {
        return new CollectorTileEntity();
    }

    protected boolean openGui(PlayerEntity player, World world, BlockPos pos) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new AssertionError((Object)"Needs to be server!");
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CollectorTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            return true;
        }
        return false;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
        }
        return 0;
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        TileEntity te;
        if (pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)).equals((Object)neighbor) && (te = world.func_175625_s(pos)) instanceof CollectorTileEntity) {
            ((CollectorTileEntity)te).clearCachedInventories();
        }
        boolean powered = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
        boolean triggered = (Boolean)state.func_177229_b((Property)TRIGGERED);
        if (powered && !triggered) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!powered && triggered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CollectorTileEntity) {
            ((CollectorTileEntity)te).collect();
        }
    }
}

