/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.tileentity;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.block.PipeBlock;
import knightminer.inspirations.utility.inventory.PipeContainer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.InventoryTileEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;

public class PipeTileEntity
extends InventoryTileEntity
implements ITickableTileEntity {
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.inspirations.pipe");
    private short cooldown = 0;
    @Nullable
    private LazyOptional<IItemHandler> facingHandler = null;
    @Nullable
    private WeakReference<HopperTileEntity> hopper;
    private final NonNullConsumer<IItemHandler> transferItem = this::transferItem;
    private final NonNullConsumer<LazyOptional<IItemHandler>> facingInvalidator = new WeakConsumerWrapper((Object)this, (te, handler) -> {
        if (te.facingHandler == handler) {
            te.clearCachedInventories();
        }
    });
    private static final String TAG_COOLDOWN = "cooldown";

    public PipeTileEntity() {
        super(InspirationsUtility.tilePipe, TITLE, 1);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)PipeBlock.FACING);
        if (!((Boolean)Config.pipeUpwards.get()).booleanValue() && facing == Direction.UP) {
            return;
        }
        this.cooldown = (short)(this.cooldown - 1);
        if (this.cooldown > 0) {
            return;
        }
        this.cooldown = 0;
        if (this.func_191420_l()) {
            return;
        }
        this.getHandler(facing).ifPresent(this.transferItem);
    }

    private LazyOptional<IItemHandler> getHandler(Direction facing) {
        LazyOptional handler;
        if (this.facingHandler != null) {
            return this.facingHandler;
        }
        assert (this.field_145850_b != null);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te != null && (handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) {
            handler.addListener(this.facingInvalidator);
            if (te instanceof HopperTileEntity) {
                this.hopper = new WeakReference<HopperTileEntity>((HopperTileEntity)te);
            }
            this.facingHandler = handler;
            return this.facingHandler;
        }
        this.facingHandler = LazyOptional.empty();
        return this.facingHandler;
    }

    private void transferItem(IItemHandler neighbor) {
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        if (ItemHandlerHelper.insertItemStacked((IItemHandler)neighbor, (ItemStack)copy, (boolean)false).func_190926_b()) {
            HopperTileEntity hop;
            if (this.hopper != null && (hop = (HopperTileEntity)this.hopper.get()) != null) {
                hop.func_145896_c(8);
            }
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                this.func_70299_a(0, ItemStack.field_190927_a);
            }
            this.cooldown = (short)8;
            this.func_70296_d();
        }
    }

    public void clearCachedInventories() {
        this.facingHandler = null;
        this.hopper = null;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.clearCachedInventories();
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        this.cooldown = (short)7;
    }

    public Container createMenu(int winId, PlayerInventory inv, PlayerEntity entity) {
        return new PipeContainer(winId, inv, this);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        this.cooldown = tags.func_74765_d(TAG_COOLDOWN);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        tags.func_74777_a(TAG_COOLDOWN, this.cooldown);
        return tags;
    }
}

