/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.chunk;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.spawn.SpawnerManager;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ChunkManager
extends Manager {
    private static Set<Chunk> chunkList = new LinkedHashSet<Chunk>();
    public static Integer maxNumberOfChunks = 1000;
    private static final Logger log = ChunkManager.getLogger(ChunkManager.class.getSimpleName());

    @SubscribeEvent
    public static void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        chunkList = new LinkedHashSet<Chunk>();
    }

    @SubscribeEvent
    public static void handleChunkLoadEvent(ChunkEvent.Load event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        Chunk chunk = (Chunk)event.getChunk();
        if (!ChunkManager.hasChunk(chunk)) {
            ChunkManager.addChunk(chunk);
            Map tileEntityMap = chunk.func_177434_r();
            for (Map.Entry tileEntityEntry : tileEntityMap.entrySet()) {
                TileEntity tileEntity = (TileEntity)tileEntityEntry.getValue();
                if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
                SpawnerManager.addSpawner((MobSpawnerTileEntity)tileEntity);
            }
        }
    }

    @SubscribeEvent
    public static void handleChunkUnloadEvent(ChunkEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        Chunk chunk = (Chunk)event.getChunk();
        if (ChunkManager.hasChunk(chunk)) {
            ChunkManager.removeChunk(chunk);
            Map tileEntityMap = chunk.func_177434_r();
            for (Map.Entry tileEntityEntry : tileEntityMap.entrySet()) {
                TileEntity tileEntity = (TileEntity)tileEntityEntry.getValue();
                if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
                SpawnerManager.removeSpawner((MobSpawnerTileEntity)tileEntity);
            }
        }
    }

    public static void addChunk(Chunk chunk) {
        log.trace("Add chunk {} at {}", (Object)chunk, (Object)chunk.func_76632_l());
        chunkList.add(chunk);
        if (chunkList.size() > maxNumberOfChunks && log.isTraceEnabled()) {
            log.trace("Should optimize chunks because {} exceeding limit of {}...", (Object)chunkList.size(), (Object)maxNumberOfChunks);
        }
    }

    public static void removeChunk(Chunk chunk) {
        log.trace("Remove chunk {} at {}", (Object)chunk, (Object)chunk.func_76632_l());
        chunkList.remove(chunk);
    }

    public static boolean hasChunk(Chunk chunk) {
        return chunkList.contains(chunk);
    }
}

