/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.entity.EntityManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CommandEntities
extends CustomCommand {
    private static final CommandEntities command = new CommandEntities();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"entities").requires(cs -> cs.func_197034_c(2))).executes((Command)command)).then(Commands.func_197057_a((String)"overview").executes(command::overview))).then(Commands.func_197057_a((String)"registry").executes(command::registry));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandEntities.sendFeedback(context, "Usage:\n/aptweaks entities overview - List of entities in the world\n/aptweaks entities registry - List of known entities from the registry");
        return 0;
    }

    public int overview(CommandContext<CommandSource> context) {
        Map<String, Set<Entity>> entities = EntityManager.getEntities();
        if (entities.isEmpty()) {
            CommandEntities.sendFeedback(context, "Unable to find any entities. Server / World is not loaded?");
            return 0;
        }
        CommandEntities.sendFeedback(context, String.format("Entity overview (%s types)\n===", entities.size()));
        log.info("Entity overview: {}", entities);
        for (Map.Entry<String, Set<Entity>> entity : entities.entrySet()) {
            CommandEntities.sendFeedback(context, String.format("%s x %s", entity.getValue().size(), entity.getKey()));
        }
        return 0;
    }

    public int registry(CommandContext<CommandSource> context) {
        Set entitiesKeys = ForgeRegistries.ENTITIES.getKeys();
        if (entitiesKeys.isEmpty()) {
            CommandEntities.sendFeedback(context, "Unable to find any entities. Server / World is not loaded?");
            return 0;
        }
        CommandEntities.sendFeedback(context, String.format("Entity registry (%s types)\n===", entitiesKeys.size()));
        log.info("Entity registry: {}", (Object)entitiesKeys);
        for (ResourceLocation entityKey : entitiesKeys) {
            CommandEntities.sendFeedback(context, String.format("\u25cb %s", entityKey));
        }
        return 0;
    }
}

