/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweaks.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaks.entity.MonsterEntityManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.monster.MonsterEntity;

public class CommandMonster
extends CustomCommand {
    private static final CommandMonster command = new CommandMonster();

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"monster").requires(cs -> cs.func_197034_c(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Map<String, Set<MonsterEntity>> monsterEntityMap = MonsterEntityManager.getMonsterEntityMap();
        if (monsterEntityMap.isEmpty()) {
            CommandMonster.sendFeedback(context, "Unable to find any monster entity. World is not loaded or nor monster spawned?");
        } else {
            CommandMonster.sendFeedback(context, String.format("Monster Entity (%s types)\n===", monsterEntityMap.size()));
            for (Map.Entry<String, Set<MonsterEntity>> monsterEntities : monsterEntityMap.entrySet()) {
                int numOfMonster = monsterEntities.getValue().size();
                if (numOfMonster <= 0) continue;
                CommandMonster.sendFeedback(context, String.format("\u221f %s %s", monsterEntities.getKey(), numOfMonster));
            }
        }
        return 0;
    }
}

