/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.config;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfigReloadEvent;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.AlexMobsConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.AquacultureConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.ArtifactsConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.DungeonsmodConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.IceAndFireConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.MekanismAdditions;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.MinecraftConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.MowziesMobsConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.MutantBeastsConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.QuarkConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.RatsConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.SavageAndRavageConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.StatuesConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.SupplementariesConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.TheAbyssConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.TheFarlandersConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.TinkersConstructConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.TwistConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.UntamedWildsConfig;
import de.markusbordihn.adaptiveperformancetweaks.config.mods.Whisperwoods;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SpawnConfigManager
extends Manager {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static Map<String, Integer> spawnConfigPerPlayer = new HashMap<String, Integer>();
    private static Map<String, Integer> spawnConfigPerWorld = new HashMap<String, Integer>();
    private static Map<String, Integer> spawnConfigSpecial = new HashMap<String, Integer>();
    private static Set<String> spawnConfigEntity = new HashSet<String>();
    private static final Logger log = SpawnConfigManager.getLogger(SpawnConfigManager.class.getSimpleName());

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        SpawnConfigManager.checkForBadCombinationOfMods();
        SpawnConfigManager.clearSpawnRates();
        SpawnConfigManager.calculateSpawnRates();
    }

    @SubscribeEvent
    public static void handleCommonConfigReloadEvent(CommonConfigReloadEvent event) {
        SpawnConfigManager.clearSpawnRates();
        SpawnConfigManager.calculateSpawnRates();
    }

    public static void checkForBadCombinationOfMods() {
        if (ModList.get().isLoaded("performant")) {
            log.error(SpawnConfigManager.getCoreModWarning("Performant"));
        }
        if (ModList.get().isLoaded("lazydfu")) {
            log.warn(SpawnConfigManager.getCoreModWarning("Lazy DataFixerUpper"));
        }
        if (ModList.get().isLoaded("sodium")) {
            log.warn(SpawnConfigManager.getCoreModWarning("Sodium"));
        }
        if (ModList.get().isLoaded("dynview")) {
            log.error("Dynamic View optimizing the view distance in a similar way like this mod. Don't use both optimizations together!");
        }
        if (ModList.get().isLoaded("incontrol")) {
            log.error("InControl controls the mob spawns and entity spawns, which could conflict with this spawn control of this mod. Don't use both optimizations together!");
        }
        if (ModList.get().isLoaded("rats")) {
            log.warn("There are known issue with the rats mod and spawn control, please not report any issue!");
        }
    }

    public static String getCoreModWarning(String modName) {
        return String.format("The mod %s use core modifications which could conflicting with this none-core mod. Do not report any issues with both mods enabled.", modName);
    }

    public static void calculateSpawnRates() {
        if (Boolean.FALSE.equals(SpawnConfigManager.COMMON.optimizePassiveMobs.get()) && Boolean.FALSE.equals(SpawnConfigManager.COMMON.optimizeNeutralMobs.get()) && Boolean.FALSE.equals(SpawnConfigManager.COMMON.optimizeHostileMobs.get()) && Boolean.FALSE.equals(SpawnConfigManager.COMMON.optimizeBossMobs.get())) {
            log.info("Disable entity spawn rates for Players and World!");
            return;
        }
        log.info("Enable pre-calculate entity spawn rates for Players and World");
        log.info("Optimize Passive Mobs: {}", (Object)Boolean.TRUE.equals(SpawnConfigManager.COMMON.optimizePassiveMobs.get()));
        log.info("Optimize Neutral Mobs: {}", (Object)Boolean.TRUE.equals(SpawnConfigManager.COMMON.optimizeNeutralMobs.get()));
        log.info("Optimize Hostile Mobs: {}", (Object)Boolean.TRUE.equals(SpawnConfigManager.COMMON.optimizeHostileMobs.get()));
        log.info("Optimize Boss Mobs: {}", (Object)Boolean.TRUE.equals(SpawnConfigManager.COMMON.optimizeBossMobs.get()));
        MinecraftConfig.addSpawnRates();
        AlexMobsConfig.addSpawnRates();
        AquacultureConfig.addSpawnRates();
        ArtifactsConfig.addSpawnRates();
        DungeonsmodConfig.addSpawnRates();
        IceAndFireConfig.addSpawnRates();
        MekanismAdditions.addSpawnRates();
        MowziesMobsConfig.addSpawnRates();
        MutantBeastsConfig.addSpawnRates();
        QuarkConfig.addSpawnRates();
        RatsConfig.addSpawnRates();
        SavageAndRavageConfig.addSpawnRates();
        StatuesConfig.addSpawnRates();
        SupplementariesConfig.addSpawnRates();
        TheAbyssConfig.addSpawnRates();
        TheFarlandersConfig.addSpawnRates();
        TinkersConstructConfig.addSpawnRates();
        TwistConfig.addSpawnRates();
        UntamedWildsConfig.addSpawnRates();
        Whisperwoods.addSpawnRates();
        log.info("Added {} player spawn rules, {} world spawn rules and {} special spawn rules.", (Object)spawnConfigPerPlayer.size(), (Object)spawnConfigPerWorld.size(), (Object)spawnConfigSpecial.size());
    }

    public static void clearSpawnRates() {
        log.info("Clearing spawn rates calculation ...");
        spawnConfigPerPlayer.clear();
        spawnConfigPerPlayer.clear();
        spawnConfigPerWorld.clear();
        spawnConfigSpecial.clear();
        spawnConfigEntity.clear();
    }

    public static void addSpawnConfigPerPlayer(String entityName, int maxNumberOfEntities) {
        spawnConfigPerPlayer.put(entityName, maxNumberOfEntities);
    }

    public static void addSpawnConfigPerWorld(String entityName, int maxNumberOfEntities) {
        spawnConfigPerWorld.put(entityName, maxNumberOfEntities);
    }

    public static void addSpawnConfigSpecial(String entityName, int maxNumberOfEntities) {
        spawnConfigSpecial.put(entityName, maxNumberOfEntities);
    }

    public static void addSpawnConfigEntity(String entityName) {
        spawnConfigEntity.add(entityName);
    }

    public static int getSpawnLimitPerPlayer(String entityName) {
        return spawnConfigPerPlayer.get(entityName);
    }

    public static int getSpawnLimitPerWorld(String entityName) {
        return spawnConfigPerWorld.get(entityName);
    }

    public static int getSpawnerListSpecial(String entityName) {
        return spawnConfigPerWorld.get(entityName);
    }

    public static boolean hasSpawnLimit(String entityName) {
        return spawnConfigEntity.contains(entityName);
    }

    public static Map<String, Integer> getSpawnConfigPerPlayer() {
        return spawnConfigPerPlayer;
    }

    public static Map<String, Integer> getSpawnConfigPerWorld() {
        return spawnConfigPerWorld;
    }

    public static Map<String, Integer> getSpawnConfigSpecial() {
        return spawnConfigSpecial;
    }

    public static Set<String> getSpawnConfigEntity() {
        return spawnConfigEntity;
    }
}

