/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.entity;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.entity.MonsterEntityManager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPosition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class EntityManager
extends Manager {
    public static final String LOG_NAME = EntityManager.class.getSimpleName();
    private static final Logger log = EntityManager.getLogger(LOG_NAME);
    private static ConcurrentHashMap<String, Set<Entity>> entityMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Set<Entity>> entityMapPerWorld = new ConcurrentHashMap();
    private static Set<String> allowList = new HashSet<String>((Collection)EntityManager.COMMON.spawnAllowList.get());
    private static Set<String> denyList = new HashSet<String>((Collection)EntityManager.COMMON.spawnDenyList.get());
    private static short ticks = 0;
    private static final short VERIFICATION_TICK = 1200;

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        entityMap = new ConcurrentHashMap();
        entityMapPerWorld = new ConcurrentHashMap();
        allowList = new HashSet<String>((Collection)EntityManager.COMMON.spawnAllowList.get());
        denyList = new HashSet<String>((Collection)EntityManager.COMMON.spawnDenyList.get());
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 1200) {
                EntityManager.verifyEntities();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.DENY) {
            log.debug("[Canceled / denied Spawner Event] Ignore spawner event {}!", (Object)event);
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!EntityManager.isRelevantEntity(entity)) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            log.debug("Player {} joined world.", (Object)entity);
            return;
        }
        String entityName = entity.func_70022_Q();
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        if (entityName == null) {
            if (entity.isMultipartEntity() || entity.func_200600_R().toString().contains("body_part")) {
                log.debug("Ignore multipart entity {} in {}.", (Object)entity, (Object)worldName);
            } else if (entity.func_145818_k_()) {
                if (log.isDebugEnabled()) {
                    String customName = entity.func_200201_e() == null ? "NULL" : entity.func_200201_e().getString();
                    log.debug("Unknown entity name for entity {} ({}) with custom name {} in {}.", (Object)entity, (Object)entity.func_200600_R(), (Object)customName, (Object)worldName);
                }
            } else {
                String entityType = entity.func_200600_R().toString();
                if (!entityType.startsWith("entity.mana-and-artifice.")) {
                    log.warn("Unknown entity name for entity {} ({}) in {}. Please report this issue under {}!", (Object)entity, (Object)entity.func_200600_R(), (Object)worldName, (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues/");
                }
            }
            return;
        }
        if (entityName.equals("mana-and-artifice:residual_magic")) {
            return;
        }
        if (denyList.contains(entityName)) {
            log.debug("Removing denied entity {} in {}", (Object)entityName, (Object)worldName);
            entity.func_70106_y();
            event.setCanceled(true);
            return;
        }
        if (allowList.contains(entityName)) {
            log.debug("Ignore allowed entity {} in {}", (Object)entityName, (Object)worldName);
            return;
        }
        if (entity.func_145818_k_()) {
            if (log.isDebugEnabled()) {
                String customName = entity.func_200201_e() == null ? "NULL" : entity.func_200201_e().getString();
                log.debug("Ignore custom entity {} with custom name {} in {}", (Object)entityName, (Object)customName, (Object)worldName);
            }
            return;
        }
        if (entity instanceof MonsterEntity) {
            MonsterEntityManager.handleMonsterEntityJoinWorldEvent(event);
        }
        EntityManager.addEntity(entity, world);
    }

    @SubscribeEvent
    public static void handleEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!EntityManager.isRelevantEntity(entity)) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            log.debug("Player {} leaved world.", (Object)entity);
            return;
        }
        String entityName = entity.func_70022_Q();
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        if (entityName == null) {
            return;
        }
        if (entity.func_145818_k_()) {
            if (log.isDebugEnabled()) {
                String customName = entity.func_200201_e() == null ? "NULL" : entity.func_200201_e().getString();
                log.debug("Ignore custom entity {} with name {} in {}", (Object)entityName, (Object)customName, (Object)worldName);
            }
        } else if (entity instanceof MonsterEntity) {
            MonsterEntityManager.handleMonsterEntityLeaveWorldEvent(event);
        }
        EntityManager.removeEntity(entity, world);
    }

    public static void addEntity(Entity entity, World world) {
        String entityName = entity.func_70022_Q();
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        String entityMapKey = '[' + worldName + ']' + entityName;
        entityMap.computeIfAbsent(entityMapKey, k -> new HashSet());
        Set<Entity> entities = entityMap.get(entityMapKey);
        entities.add(entity);
        entityMapPerWorld.computeIfAbsent(worldName, k -> new HashSet());
        Set<Entity> entitiesPerWorld = entityMapPerWorld.get(worldName);
        entitiesPerWorld.add(entity);
        log.debug("Entity {} ({}) joined {}.", (Object)entityName, (Object)entity, (Object)worldName);
    }

    public static void removeEntity(Entity entity, World world) {
        Set<Entity> entitiesPerWorld;
        String entityName = entity.func_70022_Q();
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        Set<Entity> entities = entityMap.get('[' + worldName + ']' + entityName);
        if (entities != null) {
            entities.remove(entity);
        }
        if ((entitiesPerWorld = entityMapPerWorld.get(worldName)) != null) {
            entitiesPerWorld.remove(entity);
        }
        log.debug("Entity {} ({}) leaved {}.", (Object)entityName, (Object)entity, (Object)worldName);
    }

    public static Map<String, Set<Entity>> getEntities() {
        return entityMap;
    }

    public static Integer getNumberOfEntities(String worldName, String entityName) {
        Set<Entity> entities = entityMap.get('[' + worldName + ']' + entityName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesPerWorld(String worldName) {
        Set<Entity> entities = entityMapPerWorld.get(worldName);
        if (entities == null) {
            return 0;
        }
        return entities.size();
    }

    public static Integer getNumberOfEntitiesInPlayerPositions(String worldName, String entityName, List<PlayerPosition> playerPositions) {
        if (!entityMap.contains('[' + worldName + ']' + entityName)) {
            return 0;
        }
        int counter = 0;
        HashSet entities = new HashSet(entityMap.get('[' + worldName + ']' + entityName));
        for (Entity entity : entities) {
            if (entity == null) continue;
            int x = (int)entity.func_226277_ct_();
            int y = (int)entity.func_226278_cu_();
            int z = (int)entity.func_226281_cx_();
            for (PlayerPosition playerPosition : playerPositions) {
                if (!playerPosition.isInsidePlayerViewArea(worldName, x, y, z)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static Integer getNumberOfEntitiesInChunkPosition(String worldName, Vector3d position) {
        if (!entityMap.contains(worldName)) {
            return 0;
        }
        int counter = 0;
        int chunkX = (int)position.field_72450_a >> 4;
        int chunkZ = (int)position.field_72449_c >> 4;
        HashSet entities = new HashSet(entityMapPerWorld.get(worldName));
        for (Entity entity : entities) {
            if (entity == null) continue;
            int entityChunkX = entity.field_70176_ah;
            int entityChunkZ = entity.field_70164_aj;
            if (chunkX != entityChunkX || chunkZ != entityChunkZ) continue;
            ++counter;
        }
        return counter;
    }

    public static void verifyEntities() {
        Entity entity;
        Iterator<Entity> entityIterator;
        int removedEntries = 0;
        for (Set<Entity> entities : entityMap.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = entityIterator.next();
                if (entity == null || entity.func_70089_S()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        for (Set<Entity> entities : entityMapPerWorld.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = entityIterator.next();
                if (entity == null || entity.func_70089_S()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        if (removedEntries > 0) {
            log.debug("Removed {} entity entries from the cache ...", (Object)removedEntries);
        }
    }

    public static boolean isRelevantEntity(Entity entity) {
        return !(entity instanceof ExperienceOrbEntity) && !(entity instanceof ItemEntity) && !(entity instanceof LightningBoltEntity) && !(entity instanceof FallingBlockEntity) && !(entity instanceof ProjectileEntity) && !(entity instanceof MinecartEntity) && !(entity instanceof AbstractMinecartEntity) && entity.func_70089_S();
    }
}

