/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.entity;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ExperienceOrbEntityManager
extends Manager {
    private static Map<String, Set<ExperienceOrbEntity>> experienceOrbEntityMap = new ConcurrentHashMap<String, Set<ExperienceOrbEntity>>();
    private static boolean optimizeExperienceOrbs = (Boolean)ExperienceOrbEntityManager.COMMON.optimizeExperienceOrbs.get();
    private static int experienceOrbsClusterRange = (Integer)ExperienceOrbEntityManager.COMMON.experienceOrbsClusterRange.get();
    public static final String LOG_NAME = ExperienceOrbEntityManager.class.getSimpleName();
    private static final Logger log = ExperienceOrbEntityManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        experienceOrbEntityMap = new ConcurrentHashMap<String, Set<ExperienceOrbEntity>>();
        optimizeExperienceOrbs = (Boolean)ExperienceOrbEntityManager.COMMON.optimizeExperienceOrbs.get();
        experienceOrbsClusterRange = (Integer)ExperienceOrbEntityManager.COMMON.experienceOrbsClusterRange.get();
        if (optimizeExperienceOrbs) {
            log.info("Enable clustering of Experience Orbs with a radius of {} blocks.", (Object)experienceOrbsClusterRange);
            if (ModList.get().isLoaded("clumps")) {
                log.error("WARNING: Clumps groups XP orbs together into a new single entity, which will conflict with the XP Orb feature of this mod!");
                log.warn("Don't use both optimizations together! Clustering of Experience Orbs will be automatically disabled!");
                optimizeExperienceOrbs = false;
            }
        } else {
            log.info("Disable Experience Orbs clustering ...");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleExperienceOrbEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ExperienceOrbEntity)) {
            return;
        }
        ExperienceOrbEntity experienceOrbEntity = (ExperienceOrbEntity)entity;
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        if (optimizeExperienceOrbs && experienceOrbEntity.field_70530_e <= 0) {
            log.debug("Remove Experience Orb {} with {} xp from {}.", (Object)experienceOrbEntity, (Object)experienceOrbEntity.field_70530_e, (Object)worldName);
            experienceOrbEntity.func_70106_y();
            return;
        }
        log.debug("Experience Orb {} with {} xp joined {}.", (Object)experienceOrbEntity, (Object)experienceOrbEntity.field_70530_e, (Object)worldName);
        experienceOrbEntityMap.computeIfAbsent(worldName, k -> new LinkedHashSet());
        Set<ExperienceOrbEntity> experienceOrbWorldEntities = experienceOrbEntityMap.get(worldName);
        if (optimizeExperienceOrbs && !experienceOrbWorldEntities.isEmpty()) {
            HashSet<ExperienceOrbEntity> experienceOrbsEntities = new HashSet<ExperienceOrbEntity>(experienceOrbWorldEntities);
            Iterator experienceOrbsEntitiesIterator = experienceOrbsEntities.iterator();
            int x = (int)experienceOrbEntity.func_226277_ct_();
            int y = (int)experienceOrbEntity.func_226278_cu_();
            int z = (int)experienceOrbEntity.func_226281_cx_();
            int xStart = x - experienceOrbsClusterRange;
            int yStart = y - experienceOrbsClusterRange;
            int zStart = z - experienceOrbsClusterRange;
            int xEnd = x + experienceOrbsClusterRange;
            int yEnd = y + experienceOrbsClusterRange;
            int zEnd = z + experienceOrbsClusterRange;
            while (experienceOrbsEntitiesIterator.hasNext()) {
                ExperienceOrbEntity existingExperienceOrbEntity = (ExperienceOrbEntity)experienceOrbsEntitiesIterator.next();
                int xSub = (int)existingExperienceOrbEntity.func_226277_ct_();
                int ySub = (int)existingExperienceOrbEntity.func_226278_cu_();
                int zSub = (int)existingExperienceOrbEntity.func_226281_cx_();
                if (experienceOrbEntity.func_145782_y() == existingExperienceOrbEntity.func_145782_y() || !existingExperienceOrbEntity.func_70089_S() || xStart >= xSub || xSub >= xEnd || yStart >= ySub || ySub >= yEnd || zStart >= zSub || zSub >= zEnd) continue;
                int newExperienceValue = existingExperienceOrbEntity.field_70530_e + experienceOrbEntity.field_70530_e;
                log.debug("Merge experience orb {} with {} and {} xp.", (Object)experienceOrbEntity, (Object)existingExperienceOrbEntity, (Object)newExperienceValue);
                existingExperienceOrbEntity.field_70530_e = newExperienceValue;
                experienceOrbEntity.field_70530_e = 0;
                experienceOrbEntity.func_225653_b_(existingExperienceOrbEntity.func_226277_ct_(), existingExperienceOrbEntity.func_226278_cu_(), existingExperienceOrbEntity.func_226281_cx_());
                experienceOrbEntity.func_70106_y();
                event.setCanceled(true);
                return;
            }
        }
        experienceOrbWorldEntities.add(experienceOrbEntity);
    }

    @SubscribeEvent
    public static void handleExperienceOrbEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ExperienceOrbEntity)) {
            return;
        }
        ExperienceOrbEntity experienceOrbEntity = (ExperienceOrbEntity)entity;
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        log.debug("Experience Orb {} with {} xp left {}.", (Object)experienceOrbEntity, (Object)experienceOrbEntity.field_70530_e, (Object)worldName);
        Set<ExperienceOrbEntity> experienceOrbWorldEntities = experienceOrbEntityMap.get(worldName);
        if (experienceOrbWorldEntities != null) {
            experienceOrbWorldEntities.remove(experienceOrbEntity);
        }
    }
}

