/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.entity;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.server.OptimizationEvent;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerLoadEvent;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ItemEntityManager
extends Manager {
    private static Integer maxNumberOfItems = (Integer)ItemEntityManager.COMMON.maxNumberOfItems.get();
    private static Integer maxNumberOfItemsPerType = (Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get();
    private static Map<String, Set<ItemEntity>> itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static Map<String, Set<ItemEntity>> itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
    private static boolean hasHighServerLoad = false;
    private static boolean needsOptimization = false;
    private static boolean optimizeItems = (Boolean)ItemEntityManager.COMMON.optimizeItems.get();
    private static int itemClusterRange = (Integer)ItemEntityManager.COMMON.itemsClusterRange.get();
    private static short ticks = 0;
    private static final short VERIFICATION_TICK = 600;
    public static final String LOG_NAME = ItemEntityManager.class.getSimpleName();
    private static final Logger log = ItemEntityManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        itemTypeEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
        itemWorldEntityMap = new ConcurrentHashMap<String, Set<ItemEntity>>();
        itemClusterRange = (Integer)ItemEntityManager.COMMON.itemsClusterRange.get();
        maxNumberOfItems = (Integer)ItemEntityManager.COMMON.maxNumberOfItems.get();
        maxNumberOfItemsPerType = (Integer)ItemEntityManager.COMMON.maxNumberOfItemsPerType.get();
        optimizeItems = (Boolean)ItemEntityManager.COMMON.optimizeItems.get();
        if (maxNumberOfItems < maxNumberOfItemsPerType) {
            maxNumberOfItems = maxNumberOfItemsPerType * 2;
            log.error("Max number of items could not be lower than max. number of items per type, using {} for maxNumberOfItems instead!", (Object)maxNumberOfItems);
        }
        if (optimizeItems) {
            log.info("Max number of Items allowed per world: {} / per type: {}", (Object)maxNumberOfItems, (Object)maxNumberOfItemsPerType);
            log.info("Enable clustering of items with a radius of {} blocks.", (Object)itemClusterRange);
        } else {
            log.info("Item Optimization is disabled!");
        }
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 600) {
                ItemEntityManager.verifyEntities();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        hasHighServerLoad = event.hasHighServerLoad();
        if (hasHighServerLoad) {
            needsOptimization = true;
        }
    }

    @SubscribeEvent
    public static void handleOptimizationEvent(OptimizationEvent event) {
        if (needsOptimization) {
            if (optimizeItems) {
                ItemEntityManager.optimizeItems();
            }
            needsOptimization = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleItemEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        int numberOfItemEntities;
        int numberOfItemWorldEntities;
        ItemStack itemStack;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        String itemName = itemEntity.func_92059_d().func_77973_b().getRegistryName().toString();
        if (itemName == null) {
            itemName = itemEntity.func_70022_Q();
        }
        if (itemName.equals("block.minecraft.air") || itemName.equals("minecraft:air")) {
            return;
        }
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        if (log.isDebugEnabled()) {
            log.debug("Item {} {} joined {}.", (Object)itemName, (Object)itemEntity.func_145748_c_().getString(), (Object)worldName);
        }
        String itemTypeEntityMapKey = '[' + worldName + ']' + itemName;
        itemTypeEntityMap.computeIfAbsent(itemTypeEntityMapKey, k -> new LinkedHashSet());
        Set<ItemEntity> itemTypeEntities = itemTypeEntityMap.get(itemTypeEntityMapKey);
        if (optimizeItems && (itemStack = itemEntity.func_92059_d()) != null && itemStack.func_77985_e() && itemStack.func_190916_E() < itemStack.func_77976_d() && itemStack.func_77976_d() > 1) {
            HashSet<ItemEntity> itemEntities = new HashSet<ItemEntity>(itemTypeEntities);
            Iterator itemEntitiesIterator = itemEntities.iterator();
            int x = (int)itemEntity.func_226277_ct_();
            int y = (int)itemEntity.func_226278_cu_();
            int z = (int)itemEntity.func_226281_cx_();
            int xStart = x - itemClusterRange;
            int yStart = y - itemClusterRange;
            int zStart = z - itemClusterRange;
            int xEnd = x + itemClusterRange;
            int yEnd = y + itemClusterRange;
            int zEnd = z + itemClusterRange;
            boolean itemCanSeeSky = world.func_226660_f_(itemEntity.func_233580_cy_());
            while (itemEntitiesIterator.hasNext()) {
                ItemEntity existingItemEntity = (ItemEntity)itemEntitiesIterator.next();
                int xSub = (int)existingItemEntity.func_226277_ct_();
                int ySub = (int)existingItemEntity.func_226278_cu_();
                int zSub = (int)existingItemEntity.func_226281_cx_();
                boolean existingItemCanSeeSky = world.func_226660_f_(existingItemEntity.func_233580_cy_());
                ItemStack existingItemStack = existingItemEntity.func_92059_d();
                if (itemEntity.func_145782_y() == existingItemEntity.func_145782_y() || !existingItemEntity.func_70089_S() || !ItemEntity.func_226532_a_((ItemStack)itemStack, (ItemStack)existingItemStack) || xStart >= xSub || xSub >= xEnd || (!itemCanSeeSky || !existingItemCanSeeSky) && (yStart >= ySub || ySub >= yEnd) || zStart >= zSub || zSub >= zEnd) continue;
                int newItemCount = existingItemStack.func_190916_E() + itemStack.func_190916_E();
                log.debug("Merge item {} with {} and {} items", (Object)itemEntity, (Object)existingItemEntity, (Object)newItemCount);
                ItemStack combinedItemStack = ItemEntity.func_226533_a_((ItemStack)existingItemStack, (ItemStack)itemStack, (int)64);
                existingItemEntity.func_92058_a(combinedItemStack);
                return;
            }
        }
        itemWorldEntityMap.computeIfAbsent(worldName, k -> new LinkedHashSet());
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(worldName);
        itemWorldEntities.add(itemEntity);
        if (optimizeItems && (numberOfItemWorldEntities = itemWorldEntities.size()) > maxNumberOfItems) {
            ItemEntity firsItemWorldEntity = itemWorldEntities.iterator().next();
            log.debug("[Item World Limit {}] Removing item {}", (Object)numberOfItemWorldEntities, (Object)firsItemWorldEntity);
            firsItemWorldEntity.remove(false);
            itemWorldEntities.remove(firsItemWorldEntity);
            Set<ItemEntity> itemEntities = itemTypeEntityMap.get('[' + worldName + ']' + itemName);
            if (itemEntities != null) {
                itemEntities.remove(firsItemWorldEntity);
            }
        }
        itemTypeEntities.add(itemEntity);
        if (optimizeItems && (numberOfItemEntities = itemTypeEntities.size()) > maxNumberOfItemsPerType) {
            ItemEntity firstItemEntity = itemTypeEntities.iterator().next();
            log.debug("[Item Type Limit {}] Removing item {}", (Object)numberOfItemEntities, (Object)firstItemEntity);
            firstItemEntity.remove(false);
            itemTypeEntities.remove(firstItemEntity);
            itemWorldEntities.remove(firstItemEntity);
        }
        if (optimizeItems && hasHighServerLoad && itemEntity.lifespan > 1) {
            itemEntity.lifespan = (int)Math.round((double)itemEntity.lifespan * 0.6);
        }
    }

    @SubscribeEvent
    public static void handleItemEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        Set<ItemEntity> itemTypeEntities;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        String itemName = itemEntity.func_92059_d().func_77973_b().getRegistryName().toString();
        if (itemName == null) {
            itemName = itemEntity.func_70022_Q();
        }
        if (itemName.equals("block.minecraft.air") || itemName.equals("minecraft:air")) {
            return;
        }
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        Set<ItemEntity> itemWorldEntities = itemWorldEntityMap.get(worldName);
        if (itemWorldEntities != null) {
            itemWorldEntities.remove(itemEntity);
        }
        if ((itemTypeEntities = itemTypeEntityMap.get('[' + worldName + ']' + itemName)) != null) {
            itemTypeEntities.remove(itemEntity);
            if (log.isDebugEnabled()) {
                log.debug("Item {} {} leaved {}.", (Object)itemName, (Object)itemEntity.func_145748_c_().getString(), (Object)worldName);
            }
        } else {
            log.warn("Item {} {} in {} was not tracked by item entity manager!", (Object)itemName, (Object)itemEntity.func_145748_c_().getString(), (Object)worldName);
        }
    }

    public static int optimizeItems() {
        log.debug("[Optimize Items] Received request to optimize items ...");
        int numberOfRemovedItems = 0;
        int maxNumberOfOptimizedWorldItems = (int)Math.round((double)maxNumberOfItems.intValue() * 0.9);
        for (Map.Entry<String, Set<ItemEntity>> itemWorldEntities : itemWorldEntityMap.entrySet()) {
            Set<ItemEntity> itemWorldEntitiesValues = itemWorldEntities.getValue();
            if (itemWorldEntitiesValues.size() <= maxNumberOfOptimizedWorldItems) continue;
            List sortedItemWorldEntitiesValues = itemWorldEntitiesValues.stream().sorted(Comparator.comparing(Entity::func_145782_y)).collect(Collectors.toList());
            for (int i = 0; i < sortedItemWorldEntitiesValues.size() - maxNumberOfOptimizedWorldItems; ++i) {
                ItemEntity itemEntity = (ItemEntity)sortedItemWorldEntitiesValues.get(i);
                if (!itemEntity.isAddedToWorld()) continue;
                itemEntity.remove(false);
                ++numberOfRemovedItems;
            }
        }
        int maxNumberOfOptimizedTypeItems = (int)Math.round((double)maxNumberOfItemsPerType.intValue() * 0.9);
        for (Map.Entry<String, Set<ItemEntity>> itemTypeEntities : itemTypeEntityMap.entrySet()) {
            Set<ItemEntity> itemTypeEntitiesValues = itemTypeEntities.getValue();
            if (itemTypeEntitiesValues.size() <= maxNumberOfOptimizedTypeItems) continue;
            List sortedItemTypeEntitiesValues = itemTypeEntitiesValues.stream().sorted(Comparator.comparing(Entity::func_145782_y)).collect(Collectors.toList());
            for (int i = 0; i < sortedItemTypeEntitiesValues.size() - maxNumberOfOptimizedTypeItems; ++i) {
                ItemEntity itemEntity = (ItemEntity)sortedItemTypeEntitiesValues.get(i);
                if (!itemEntity.isAddedToWorld()) continue;
                itemEntity.remove(false);
                ++numberOfRemovedItems;
            }
        }
        if (numberOfRemovedItems > 0) {
            log.debug("[Optimized Items] Removed {} items from all worlds!", (Object)numberOfRemovedItems);
        } else {
            log.debug("[Optimized Items] Found no relevant items which should be removed!");
        }
        return numberOfRemovedItems;
    }

    public static Integer getNumberOfItems(String worldName, String itemName) {
        Set<ItemEntity> itemEntities = itemTypeEntityMap.get('[' + worldName + ']' + itemName);
        if (itemEntities == null) {
            return 0;
        }
        return itemEntities.size();
    }

    public static Map<String, Set<ItemEntity>> getItemTypeEntityMap() {
        return itemTypeEntityMap;
    }

    public static void verifyEntities() {
        Entity entity;
        Iterator<ItemEntity> entityIterator;
        int removedEntries = 0;
        for (Set<ItemEntity> entities : itemTypeEntityMap.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = (Entity)entityIterator.next();
                if (entity == null || entity.func_70089_S()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        for (Set<ItemEntity> entities : itemWorldEntityMap.values()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                entity = (Entity)entityIterator.next();
                if (entity == null || entity.func_70089_S()) continue;
                entityIterator.remove();
                ++removedEntries;
            }
        }
        if (removedEntries > 0) {
            log.debug("[Verification] Removed {} item entries from the cache ...", (Object)removedEntries);
        }
    }
}

