/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.player;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerPositionManager;
import de.markusbordihn.adaptiveperformancetweaks.player.PlayerValidation;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerManager
extends Manager {
    private static Set<PlayerValidation> playerValidationList = new HashSet<PlayerValidation>();
    private static boolean hasPlayers = false;
    private static int playerCount = 0;
    private static short ticks = 0;
    private static int validationTimeout = 90;
    private static boolean optimizePlayerLogin = (Boolean)PlayerManager.COMMON.optimizePlayerLogin.get();
    public static final String LOG_NAME = PlayerPositionManager.class.getSimpleName();
    private static final Logger log = PlayerManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        playerValidationList = new HashSet<PlayerValidation>();
        hasPlayers = false;
        playerCount = 0;
        optimizePlayerLogin = (Boolean)PlayerManager.COMMON.optimizePlayerLogin.get();
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(FMLServerStartingEvent event) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            playerValidationList.add(new PlayerValidation(player));
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        String username = event.getPlayer().func_200200_C_().getString();
        if (!username.isEmpty()) {
            log.debug("Player {} {} logged in.", (Object)username, (Object)event.getEntity());
            ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(username);
            if (optimizePlayerLogin) {
                player.func_82142_c(true);
                player.func_184224_h(true);
                player.func_70691_i(1.0f);
            }
            playerValidationList.add(new PlayerValidation(player));
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.getPlayer().func_200200_C_().getString();
        if (!username.isEmpty()) {
            log.debug("Player {} logged out.", (Object)event.getEntity());
            PlayerManager.removePlayer(username);
        }
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ticks = (short)(ticks + 1);
            return;
        }
        if (ticks == 75) {
            for (PlayerValidation playerValidation : playerValidationList) {
                String username = playerValidation.getUsername();
                boolean foundPlayer = false;
                if (playerValidation.hasPlayerMoved()) {
                    log.debug("User {} was successful validated ...", (Object)username);
                    PlayerManager.addPlayer(username);
                    foundPlayer = true;
                } else if (playerValidation.getValidationTimeElapsed() / 1000L >= (long)validationTimeout) {
                    log.warn("User validation for {} timed out after {} sec", (Object)username, (Object)validationTimeout);
                    PlayerManager.addPlayer(username);
                    foundPlayer = true;
                }
                if (!foundPlayer) continue;
                break;
            }
            ticks = 0;
        }
    }

    private static void addPlayer(String username) {
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(username);
        try {
            for (PlayerValidation playerValidation : playerValidationList) {
                if (!username.equals(playerValidation.getUsername())) continue;
                log.debug("Found player {} with player validation {}", (Object)player, (Object)playerValidation);
                if (optimizePlayerLogin) {
                    if (player.func_82150_aj()) {
                        player.func_82142_c(false);
                    }
                    if (player.func_190530_aW()) {
                        player.func_184224_h(false);
                    }
                }
                playerValidationList.remove(playerValidation);
                break;
            }
        }
        catch (ConcurrentModificationException error) {
            log.error("Unexpected error during adding player. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues/", (Object)error);
        }
        playerCount = ServerLifecycleHooks.getCurrentServer().func_71233_x();
        hasPlayers = true;
        log.debug("Added {}", (Object)username);
    }

    private static void removePlayer(String username) {
        try {
            for (PlayerValidation playerValidation : playerValidationList) {
                if (!username.equals(playerValidation.getUsername())) continue;
                playerValidationList.remove(playerValidation);
                break;
            }
        }
        catch (ConcurrentModificationException error) {
            log.error("Unexpected error during removing player. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues/", (Object)error);
        }
        hasPlayers = --playerCount > 0;
        log.debug("Remove {} from PlayerMap: {}", (Object)username);
    }

    public static Set<PlayerValidation> getPlayerValidationList() {
        return playerValidationList;
    }

    public static boolean hasPlayers() {
        return hasPlayers;
    }

    public static int getNumberOfPlayers() {
        return playerCount;
    }
}

