/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.player;

import de.markusbordihn.adaptiveperformancetweaks.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaks.world.WorldViewManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;

public class PlayerPosition {
    private ServerPlayerEntity player;
    private String playerName = "";
    private String worldName = "";
    private boolean canSeeSky = false;
    private boolean isUnderWater = false;
    private boolean viewAreaCalculated = false;
    private long lastActionTime = 0L;
    private int posX = 0;
    private int posY = 0;
    private int posZ = 0;
    private int viewAreaStartX = 0;
    private int viewAreaStartY = 0;
    private int viewAreaStartZ = 0;
    private int viewAreaStopX = 0;
    private int viewAreaStopY = 0;
    private int viewAreaStopZ = 0;
    private int viewAreaXFactor = 32;
    private int viewAreaYFactor = 16;
    private int viewAreaZFactor = 32;
    private int viewDistance = 8;
    private int viewAreaXFactorBase;
    private int viewAreaYFactorBase;
    private int viewAreaZFactorBase;
    private double viewAreaDistanceFactorBase;
    private static final int OVERGROUND_Y = 63;
    private static final int OVERGROUND_Y_MIN_VIEW = 51;
    private static final int MAX_BUILD_HEIGHT = 320;

    public PlayerPosition(ServerPlayerEntity player) {
        this.viewAreaXFactorBase = (Integer)CommonConfig.COMMON.viewAreaXFactor.get();
        this.viewAreaYFactorBase = (Integer)CommonConfig.COMMON.viewAreaYFactor.get();
        this.viewAreaZFactorBase = (Integer)CommonConfig.COMMON.viewAreaZFactor.get();
        this.viewAreaDistanceFactorBase = (Double)CommonConfig.COMMON.viewAreaDistanceFactor.get();
        this.player = player;
        this.playerName = player.func_200200_C_().getString();
        this.updatePosition(player.func_71121_q().func_234923_W_().func_240901_a_().toString());
        this.calculateViewArea();
    }

    public boolean update(ServerPlayerEntity player) {
        return this.update(player.func_71121_q().func_234923_W_().func_240901_a_().toString());
    }

    public boolean update(String worldName) {
        if (!this.worldName.equals(worldName) || this.viewDistance != WorldViewManager.getViewDistance(worldName) || this.hasChangedPosition() || this.lastActionTime != this.player.func_154331_x()) {
            this.updatePosition(worldName);
            return true;
        }
        return false;
    }

    public void updatePosition(String worldName) {
        this.lastActionTime = this.player.func_154331_x();
        Vector3d position = this.player.func_213303_ch();
        this.posX = (int)position.field_72450_a;
        this.posY = (int)position.field_72448_b;
        this.posZ = (int)position.field_72449_c;
        this.canSeeSky = this.player.func_71121_q().func_226660_f_(this.player.func_233580_cy_());
        this.isUnderWater = this.player.func_204231_K();
        if (!this.worldName.equals(worldName)) {
            this.worldName = worldName;
        }
        this.updateViewDistance(WorldViewManager.getViewDistance(worldName));
        this.viewAreaCalculated = false;
    }

    public void updateViewDistance(int viewDistance) {
        int viewDistanceFactor = (int)Math.round((double)this.viewDistance * this.viewAreaDistanceFactorBase);
        this.viewDistance = viewDistance;
        this.viewAreaXFactor = Math.max(this.viewAreaXFactorBase, this.viewAreaXFactorBase * viewDistanceFactor);
        this.viewAreaYFactor = Math.max(this.viewAreaYFactorBase, this.viewAreaYFactorBase * viewDistanceFactor);
        this.viewAreaZFactor = Math.max(this.viewAreaZFactorBase, this.viewAreaZFactorBase * viewDistanceFactor);
    }

    public boolean isInsidePlayerViewArea(String worldName, int x, int y, int z) {
        if (!this.worldName.equals(worldName)) {
            return false;
        }
        if (!this.viewAreaCalculated) {
            this.calculateViewArea();
        }
        return this.viewAreaStartX < x && x < this.viewAreaStopX && this.viewAreaStartY < y && y < this.viewAreaStopY && this.viewAreaStartZ < z && z < this.viewAreaStopZ;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean hasChangedPosition() {
        Vector3d currentPosition = this.player.func_213303_ch();
        return Integer.compare(this.posX, (int)currentPosition.field_72450_a) != 0 || Integer.compare(this.posY, (int)currentPosition.field_72448_b) != 0 || Integer.compare(this.posZ, (int)currentPosition.field_72449_c) != 0;
    }

    private void calculateViewArea() {
        this.viewAreaStartX = this.posX - this.viewAreaXFactor;
        this.viewAreaStopX = this.posX + this.viewAreaXFactor;
        this.viewAreaStartZ = this.posZ - this.viewAreaZFactor;
        this.viewAreaStopZ = this.posZ + this.viewAreaZFactor;
        this.viewAreaStartY = this.posY - this.viewAreaYFactor;
        this.viewAreaStopY = this.posY + this.viewAreaYFactor;
        if ("minecraft:overworld".equals(this.worldName)) {
            if (this.posY >= 63 && this.canSeeSky) {
                this.viewAreaStartY = 51;
                this.viewAreaStopY = 320;
            } else if (this.posY >= 63) {
                this.viewAreaStartY = this.posY - this.viewAreaYFactor < 51 ? 51 : this.posY - this.viewAreaYFactor;
                this.viewAreaStopY = this.posY + this.viewAreaYFactor;
            } else if (this.canSeeSky) {
                this.viewAreaStartY = this.posY - this.viewAreaYFactor;
                this.viewAreaStopY = (int)Math.round((double)this.posY + (double)this.viewAreaYFactor * 2.0);
            }
        }
        this.viewAreaCalculated = true;
    }

    public String toString() {
        if (!this.viewAreaCalculated) {
            this.calculateViewArea();
        }
        return "PlayerPosition[Player{name: '" + this.playerName + "', world: '" + this.worldName + "', x:" + this.posX + ", y:" + this.posY + ", z:" + this.posZ + "}, Range{x:" + this.viewAreaStartX + " to " + this.viewAreaStopX + ", y:" + this.viewAreaStartY + " to " + this.viewAreaStopY + ", z:" + this.viewAreaStartZ + " to " + this.viewAreaStopZ + "}, Meta{canSeeSky: " + this.canSeeSky + ", isUnderWater: " + this.isUnderWater + "}]";
    }
}

