/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.server;

import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoad;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class ServerWorldLoadEvent
extends Event {
    private ServerWorld serverWorld;
    private ServerWorldLoad.ServerWorldLoadLevel lastServerWorldLoadLevel = ServerWorldLoad.ServerWorldLoadLevel.NORMAL;
    private ServerWorldLoad.ServerWorldLoadLevel serverWorldLoadLevel = ServerWorldLoad.ServerWorldLoadLevel.NORMAL;
    private String serverWorldName;
    private double serverWorldLoadLevelFactor = 0.0;
    private int playerCount = 0;

    public ServerWorldLoadEvent(ServerWorld serverWorld, ServerWorldLoad.ServerWorldLoadLevel serverWorldLoadLevel, ServerWorldLoad.ServerWorldLoadLevel lastServerWorldLoadLevel) {
        this.playerCount = serverWorld.func_217369_A().size();
        this.serverWorld = serverWorld;
        this.serverWorldName = serverWorld.func_201672_e().func_234923_W_().func_240901_a_().toString();
        this.lastServerWorldLoadLevel = lastServerWorldLoadLevel;
        this.serverWorldLoadLevel = serverWorldLoadLevel;
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public ServerWorld getServerWorld() {
        return this.serverWorld;
    }

    public String getServerWorldName() {
        return this.serverWorldName;
    }

    public ServerWorldLoad.ServerWorldLoadLevel getServerWorldLoadLevel() {
        return this.serverWorldLoadLevel;
    }

    public double getServerWorldLoadLevelFactor() {
        if (this.serverWorldLoadLevelFactor == 0.0) {
            this.serverWorldLoadLevelFactor = this.calculateServerWorldLoadLevelFactor();
        }
        return this.serverWorldLoadLevelFactor;
    }

    public double calculateServerWorldLoadLevelFactor() {
        if (!(this.serverWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.VERY_LOW && this.serverWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.LOW && this.serverWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.NORMAL || this.lastServerWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.VERY_LOW && this.lastServerWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.LOW && this.lastServerWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.NORMAL)) {
            return 1.0;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.NORMAL && this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.MEDIUM) {
            return 0.9;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.NORMAL && (this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.HIGH || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH)) {
            return 0.8;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.MEDIUM && (this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.MEDIUM || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.NORMAL || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_LOW || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.LOW)) {
            return 0.7;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.MEDIUM && (this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.HIGH || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH)) {
            return 0.6;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.HIGH && this.lastServerWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.HIGH && this.lastServerWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH) {
            return 0.5;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.HIGH) {
            return 0.4;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH && this.lastServerWorldLoadLevel != ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH) {
            return 0.3;
        }
        if (this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH) {
            return 0.2;
        }
        return 1.0;
    }

    public boolean hasHighServerWorldLoad() {
        return this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.MEDIUM || this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.HIGH || this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.HIGH || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_HIGH;
    }

    public boolean hasNormalServerWorldLoad() {
        return this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.NORMAL && (this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_LOW || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.LOW || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.NORMAL);
    }

    public boolean hasLowServerWorldLoad() {
        return this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_LOW || this.serverWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.LOW && (this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.VERY_LOW || this.lastServerWorldLoadLevel == ServerWorldLoad.ServerWorldLoadLevel.LOW);
    }

    public boolean hasChanged() {
        return this.serverWorldLoadLevel == this.lastServerWorldLoadLevel;
    }
}

