/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.spawn;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import de.markusbordihn.adaptiveperformancetweaks.entity.EntityManager;
import de.markusbordihn.adaptiveperformancetweaks.server.ServerWorldLoadEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SpawnerManager
extends Manager {
    private static Map<String, Double> serverWorldLoadFactorMap = new HashMap<String, Double>();
    private static Set<MobSpawnerTileEntity> spawnerList = new HashSet<MobSpawnerTileEntity>();
    private static Set<TileEntity> unknownSpawnerList = new HashSet<TileEntity>();
    private static boolean spawnerEnabled = (Boolean)SpawnerManager.COMMON.spawnerEnabled.get();
    private static int spawnerMaxEntityPerChunk = (Integer)SpawnerManager.COMMON.spawnerMaxEntityPerChunk.get();
    private static int spawnerMaxEntityPerWorld = (Integer)SpawnerManager.COMMON.spawnerMaxEntityPerWorld.get();
    public static final String LOG_NAME = SpawnerManager.class.getSimpleName();
    private static final Logger log = SpawnerManager.getLogger(LOG_NAME);

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        serverWorldLoadFactorMap = new HashMap<String, Double>();
        spawnerList = new HashSet<MobSpawnerTileEntity>();
        spawnerEnabled = (Boolean)SpawnerManager.COMMON.spawnerEnabled.get();
        spawnerMaxEntityPerWorld = (Integer)SpawnerManager.COMMON.spawnerMaxEntityPerWorld.get();
        spawnerMaxEntityPerChunk = (Integer)SpawnerManager.COMMON.spawnerMaxEntityPerChunk.get();
        if (spawnerEnabled) {
            log.info("\u2713 Optimize Spawner with a limit of {} per world and {} per chunk.", (Object)spawnerMaxEntityPerWorld, (Object)spawnerMaxEntityPerChunk);
        }
    }

    @SubscribeEvent
    public static void handleServerWorldLoadEvent(ServerWorldLoadEvent event) {
        if (event.hasChanged()) {
            String worldName = event.getServerWorldName();
            serverWorldLoadFactorMap.put(worldName, event.getServerWorldLoadLevelFactor());
        }
    }

    @SubscribeEvent
    public static void handleBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        Block block = event.getState().func_177230_c();
        if (block != Blocks.field_150474_ac) {
            return;
        }
        TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
        if (tileEntity != null) {
            SpawnerManager.addSpawner(tileEntity);
        }
    }

    @SubscribeEvent
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        Block block = event.getState().func_177230_c();
        if (block != Blocks.field_150474_ac) {
            return;
        }
        TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
        if (tileEntity != null) {
            SpawnerManager.removeSpawner(tileEntity);
        }
    }

    @SubscribeEvent
    public static void handleLivingSpecialSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        AbstractSpawner spawner = event.getSpawner();
        if (spawner == null) {
            return;
        }
        if (event.isCanceled() || event.getResult() == Event.Result.DENY) {
            log.debug("[Canceled / denied Spawner Event] Ignore spawner event {}!", (Object)event);
            return;
        }
        TileEntity tileEntity = event.getWorld().func_175625_s(spawner.func_177221_b());
        if (tileEntity != null) {
            SpawnerManager.addSpawner(tileEntity);
        }
        if (!spawnerEnabled) {
            return;
        }
        Entity entity = event.getEntity();
        World world = spawner.func_98271_a();
        String worldName = world.func_234923_W_().func_240901_a_().toString();
        double serverWorldLoadFactor = serverWorldLoadFactorMap.getOrDefault(worldName, 1.0);
        int entitiesPerWorld = EntityManager.getNumberOfEntitiesPerWorld(worldName);
        if ((double)entitiesPerWorld * serverWorldLoadFactor >= (double)spawnerMaxEntityPerWorld) {
            log.debug("[Spawner World Limit] Denied spawn event for {} from {} in {}!", (Object)entity, (Object)spawner, (Object)worldName);
            event.setResult(Event.Result.DENY);
            return;
        }
        int entitiesInChunk = EntityManager.getNumberOfEntitiesInChunkPosition(worldName, entity.func_213303_ch());
        if ((double)entitiesInChunk * serverWorldLoadFactor >= (double)spawnerMaxEntityPerChunk) {
            log.debug("[Spawner Chunk Limit] Denied spawn event for {} from {} in {}!", (Object)entity, (Object)spawner, (Object)worldName);
            event.setResult(Event.Result.DENY);
            return;
        }
        log.debug("[Allow Spawner Spawn] For {} from {} in {}.", (Object)entity, (Object)spawner, (Object)worldName);
        event.setResult(Event.Result.DEFAULT);
    }

    public static void addSpawner(TileEntity tileEntity) {
        if (tileEntity instanceof MobSpawnerTileEntity) {
            SpawnerManager.addSpawner((MobSpawnerTileEntity)tileEntity);
        } else if (!unknownSpawnerList.contains(tileEntity)) {
            String worldName = tileEntity.func_145831_w().func_234923_W_().func_240901_a_().toString();
            log.debug("[Unknown Custom Spawner] Found unsupported spawner {} at {} in {} which is not from type net.minecraft.tileentity.MobSpawnerTileEntity!", (Object)tileEntity, (Object)tileEntity.func_174877_v(), (Object)worldName);
            unknownSpawnerList.add(tileEntity);
        }
    }

    public static void addSpawner(AbstractSpawner spawner) {
        TileEntity tileEntity = spawner.func_98271_a().func_175625_s(spawner.func_177221_b());
        SpawnerManager.addSpawner(tileEntity);
    }

    public static void addSpawner(MobSpawnerTileEntity mobSpawnerTileEntity) {
        if (spawnerList.contains(mobSpawnerTileEntity)) {
            return;
        }
        String worldName = mobSpawnerTileEntity.func_145831_w().func_234923_W_().func_240901_a_().toString();
        CompoundNBT spawnerData = mobSpawnerTileEntity.serializeNBT();
        String spawnEntityId = spawnerData.func_74775_l("SpawnData").func_74779_i("id");
        log.debug("[Spawner] {} at {} in {} with {}", (Object)spawnEntityId, (Object)mobSpawnerTileEntity.func_174877_v(), (Object)worldName);
        spawnerList.add(mobSpawnerTileEntity);
    }

    public static void removeSpawner(TileEntity tileEntity) {
        if (tileEntity instanceof MobSpawnerTileEntity) {
            SpawnerManager.removeSpawner((MobSpawnerTileEntity)tileEntity);
        }
    }

    public static void removeSpawner(AbstractSpawner spawner) {
        TileEntity tileEntity = spawner.func_98271_a().func_175625_s(spawner.func_177221_b());
        SpawnerManager.removeSpawner(tileEntity);
    }

    public static void removeSpawner(MobSpawnerTileEntity mobSpawnerTileEntity) {
        spawnerList.remove(mobSpawnerTileEntity);
    }

    public static Set<MobSpawnerTileEntity> getSpawnerList() {
        return spawnerList;
    }
}

